/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenSwitcherGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.StringUtils;

public class BlockModelSwitcher
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public BlockModelSwitcher() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(50.0f, 1200.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        Direction value = (Direction)state.m_61143_((Property)FACING);
        if (direction != null) {
            return direction == value.m_122427_() || direction == value.m_122428_();
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TileEntityModelSwitcher(pPos, pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        TileEntityModelSwitcher switcher;
        if (pLevel.f_46443_) {
            return;
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        boolean leftSignal = pLevel.m_46681_(pPos.m_121955_(direction.m_122428_().m_122436_()), direction.m_122428_()) > 0;
        boolean rightSignal = pLevel.m_46681_(pPos.m_121955_(direction.m_122427_().m_122436_()), direction.m_122427_()) > 0;
        boolean hasSignal = leftSignal || rightSignal;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TileEntityModelSwitcher && pLevel instanceof ServerLevel && (switcher = (TileEntityModelSwitcher)blockEntity).isPowered() != hasSignal) {
            switcher.setPowered(!switcher.isPowered());
            if (!switcher.isPowered()) {
                return;
            }
            UUID uuid = switcher.getUuid();
            if (uuid == null) {
                return;
            }
            int index = this.calculateIndex(leftSignal, switcher.getInfoList().size(), switcher.getIndex());
            switcher.setIndex(index);
            ServerLevel serverLevel = (ServerLevel)pLevel;
            Entity entity = serverLevel.m_8791_(uuid);
            if (entity instanceof EntityMaid && entity.m_6084_()) {
                this.setMaidData(switcher, (EntityMaid)entity);
            }
        }
    }

    private void setMaidData(TileEntityModelSwitcher switcher, EntityMaid maid) {
        TileEntityModelSwitcher.ModeInfo modelInfo = switcher.getModelInfo();
        if (modelInfo != null) {
            maid.setModelId(modelInfo.getModelId().toString());
            if (StringUtils.isNotBlank((CharSequence)modelInfo.getText())) {
                maid.m_6593_((Component)Component.m_237113_((String)modelInfo.getText()));
                maid.m_20340_(true);
            } else {
                maid.m_6593_(null);
                maid.m_20340_(false);
            }
            BlockPos blockPos = maid.m_20183_();
            maid.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            maid.m_146922_(modelInfo.getDirection().m_122435_());
            maid.m_5616_(modelInfo.getDirection().m_122435_());
            maid.m_5618_(modelInfo.getDirection().m_122435_());
        }
    }

    private int calculateIndex(boolean leftSignal, int size, int index) {
        index = leftSignal ? (index < size - 1 ? ++index : 0) : (index > 0 ? --index : size - 1);
        return index;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.m_7702_(pos) instanceof TileEntityModelSwitcher) {
            if (!worldIn.f_46443_) {
                NetworkHandler.sendToClientPlayer(new OpenSwitcherGuiMessage(pos), player);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity te = pLevel.m_7702_(pPos);
        if (te instanceof TileEntityModelSwitcher) {
            TileEntityModelSwitcher tileEntityModelSwitcher = (TileEntityModelSwitcher)te;
            ItemModelSwitcher.itemStackToTileEntity(pStack, tileEntityModelSwitcher);
            tileEntityModelSwitcher.refresh();
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityModelSwitcher) {
            BlockModelSwitcher.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)ItemModelSwitcher.tileEntityToItemStack((TileEntityModelSwitcher)te));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

