/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmMoveTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmPlantTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public interface IFarmTask
extends IMaidTask {
    public boolean isSeed(ItemStack var1);

    public boolean canHarvest(EntityMaid var1, BlockPos var2, BlockState var3);

    public void harvest(EntityMaid var1, BlockPos var2, BlockState var3);

    public boolean canPlant(EntityMaid var1, BlockPos var2, BlockState var3, ItemStack var4);

    public ItemStack plant(EntityMaid var1, BlockPos var2, BlockState var3, ItemStack var4);

    default public double getCloseEnoughDist() {
        return 1.0;
    }

    default public boolean checkCropPosAbove() {
        return true;
    }

    @Override
    default public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_FARM.get(), 0.5f);
    }

    @Override
    default public List<Pair<Integer, Behavior<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidFarmMoveTask maidFarmMoveTask = new MaidFarmMoveTask(this, 0.6f);
        MaidFarmPlantTask maidFarmPlantTask = new MaidFarmPlantTask(this);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)maidFarmMoveTask)), Pair.of((Object)6, (Object)((Object)maidFarmPlantTask))});
    }
}

