/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public interface IAttackTask
extends IMaidTask {
    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(mobs -> mobs.m_186116_(e -> maid.m_6779_((LivingEntity)e) && maid.m_21444_(e.m_20183_())));
    }

    private static boolean checkCanAttackEntity(LivingEntity target) {
        if (target instanceof Player) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)target;
            return tamableAnimal.m_21805_() == null;
        }
        return true;
    }

    default public boolean canAttack(EntityMaid maid, LivingEntity target) {
        LivingEntity maidLastHurtByMob;
        LivingEntity livingEntity = maid.m_21826_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LivingEntity lastHurtByMob = player.m_21188_();
            if (target.equals((Object)lastHurtByMob) && IAttackTask.checkCanAttackEntity(lastHurtByMob)) {
                return true;
            }
            LivingEntity lastHurtMob = player.m_21214_();
            if (target.equals((Object)lastHurtMob) && IAttackTask.checkCanAttackEntity(lastHurtMob)) {
                return true;
            }
        }
        if (target.equals((Object)(maidLastHurtByMob = maid.m_21188_())) && IAttackTask.checkCanAttackEntity(maidLastHurtByMob)) {
            return true;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (key != null && ((List)MaidConfig.MAID_ATTACK_IGNORE.get()).contains(key.toString())) {
            return false;
        }
        return target instanceof Enemy;
    }

    default public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean doExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }
}

