/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.entity;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.ConvertMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public interface IMaid {
    @Nullable
    public static IMaid convert(Mob mob) {
        if (mob instanceof IMaid) {
            IMaid maid = (IMaid)mob;
            return maid;
        }
        ConvertMaidEvent event = new ConvertMaidEvent(mob);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getMaid();
    }

    @Nullable
    public static EntityMaid convertToMaid(Mob mob) {
        IMaid convert = IMaid.convert(mob);
        if (convert == null) {
            return null;
        }
        return convert.asStrictMaid();
    }

    default public ItemStack getBackpackShowItem() {
        return ItemStack.f_41583_;
    }

    default public IMaidBackpack getMaidBackpackType() {
        return BackpackManager.getEmptyBackpack();
    }

    @Nullable
    default public EntityMaid asStrictMaid() {
        return null;
    }

    public String getModelId();

    public Mob asEntity();
}

