/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.inventory.menu;

import com.aetherteam.aether.inventory.container.LoreInventory;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LoreBookMenu
extends AbstractContainerMenu {
    private static final Map<Predicate<ItemStack>, String> LORE_ENTRY_OVERRIDES = new HashMap<Predicate<ItemStack>, String>();
    private final LoreInventory loreInventory;
    private boolean loreEntryExists;

    public LoreBookMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, new LoreInventory(playerInventory.f_35978_));
    }

    public LoreBookMenu(int id, Inventory playerInventory, LoreInventory loreInventory) {
        super((MenuType)AetherMenuTypes.BOOK_OF_LORE.get(), id);
        LoreBookMenu.m_38869_((Container)loreInventory, (int)1);
        this.loreInventory = loreInventory;
        loreInventory.setMenu(this);
        loreInventory.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new Slot((Container)loreInventory, 0, 83, 63));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + k * 9 + 9, 48 + i1 * 18, 113 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, 48 + l * 18, 171));
        }
    }

    public boolean m_6875_(Player player) {
        return this.loreInventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (index < 1 ? !this.m_38903_(itemStack1, 1, 37, true) : !this.m_38903_(itemStack1, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack1);
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = this.loreInventory.m_8020_(0);
            if (!stack.m_41619_()) {
                if (player.m_6084_() && !serverPlayer.m_9232_()) {
                    player.m_150109_().m_150079_(stack);
                } else {
                    player.m_36176_(stack, false);
                }
                this.loreInventory.m_6836_(0, ItemStack.f_41583_);
            }
        }
        this.loreInventory.m_5785_(player);
    }

    public boolean getLoreEntryExists() {
        return this.loreEntryExists;
    }

    public void setLoreEntryExists(boolean loreEntryExists) {
        this.loreEntryExists = loreEntryExists;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLoreEntryOverride(Predicate<ItemStack> predicate, String entry) {
        LORE_ENTRY_OVERRIDES.putIfAbsent(predicate, entry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLoreEntryKey(ItemStack stack) {
        for (Predicate<ItemStack> predicate : LORE_ENTRY_OVERRIDES.keySet()) {
            if (!predicate.test(stack)) continue;
            return LORE_ENTRY_OVERRIDES.get(predicate);
        }
        return "lore." + stack.m_41778_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean loreEntryKeyExists(ItemStack stack) {
        return I18n.m_118936_((String)this.getLoreEntryKey(stack));
    }
}

