/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.gui.component.inventory.AccessoryButton;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT})
public class GuiListener {
    @SubscribeEvent
    public static void onGuiInitialize(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (GuiHooks.isAccessoryButtonEnabled()) {
            Tuple<Integer, Integer> offsets = AccessoriesScreen.getButtonOffset(screen);
            AccessoryButton inventoryAccessoryButton = GuiHooks.setupAccessoryButton(screen, offsets);
            if (inventoryAccessoryButton != null) {
                event.addListener((GuiEventListener)inventoryAccessoryButton);
            }
        } else if (screen instanceof PauseScreen) {
            ImageButton skinsButton = GuiHooks.createSkinsButton(screen);
            event.addListener((GuiEventListener)skinsButton);
            ImageButton customizationsButton = GuiHooks.createCustomizationsButton(screen);
            if (customizationsButton != null) {
                event.addListener((GuiEventListener)customizationsButton);
            }
        }
    }

    @SubscribeEvent
    public static void onGuiDraw(ScreenEvent.Render event) {
        Screen screen = event.getScreen();
        PoseStack poseStack = event.getPoseStack();
        if (!ModList.get().isLoaded("tipsmod")) {
            GuiHooks.drawTrivia(screen, poseStack);
        }
        GuiHooks.drawAetherTravelMessage(screen, poseStack);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            GuiHooks.handlePatreonRefreshRebound();
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        GuiHooks.openAccessoryMenu();
        GuiHooks.closeContainerMenu(event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        UUID bossUUID = bossEvent.m_18860_();
        if (GuiHooks.isAetherBossBar(bossUUID)) {
            GuiHooks.drawBossHealthBar(event.getPoseStack(), event.getX(), event.getY(), bossEvent);
            event.setIncrement(event.getIncrement() + 13);
        }
    }
}

