/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.machine.BrewerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineBrewerScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class BrewerRecipeCategory
extends ThermalRecipeCategory<BrewerRecipe> {
    protected IDrawableStatic tankInput;
    protected IDrawableStatic tankOutput;
    protected IDrawableStatic inputOverlay;
    protected IDrawableStatic outputOverlay;

    public BrewerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<BrewerRecipe> type) {
        super(guiHelper, icon, type);
        this.background = guiHelper.drawableBuilder(MachineBrewerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_brewer")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(0);
        this.tankInput = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOutput = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.inputOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.outputOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(0), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<BrewerRecipe> getRecipeType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BrewerRecipe recipe, IFocusGroup focuses) {
        List inputs = recipe.getInputItems();
        List inputFluids = recipe.getInputFluids();
        List outputFluids = recipe.getOutputFluids();
        builder.addSlot(RecipeIngredientRole.INPUT, 52, 15).addIngredients((Ingredient)inputs.get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(((FluidIngredient)inputFluids.get(0)).getFluids()))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.inputOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of((FluidStack)outputFluids.get(0)))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.outputOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(BrewerRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 78, 24);
        this.tankInput.draw(matrixStack, 24, 10);
        this.tankOutput.draw(matrixStack, 115, 10);
        this.speedBackground.draw(matrixStack, 52, 34);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((PoseStack)matrixStack, (int)78, (int)24, (FluidStack)((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()[0], (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 78, 24);
            this.progressFluid.draw(matrixStack, 78, 24);
        } else {
            this.progress.draw(matrixStack, 78, 24);
        }
        this.speed.draw(matrixStack, 52, 34);
    }
}

