/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.common.effects;

import dev.architectury.networking.NetworkManager;
import dev.mayaqq.estrogen.client.Dash;
import dev.mayaqq.estrogen.config.EstrogenConfig;
import dev.mayaqq.estrogen.networking.EstrogenC2S;
import dev.mayaqq.estrogen.networking.EstrogenStatusEffectSender;
import dev.mayaqq.estrogen.registry.client.EstrogenKeybinds;
import dev.mayaqq.estrogen.registry.common.EstrogenAttributes;
import dev.mayaqq.estrogen.registry.common.EstrogenEffects;
import dev.mayaqq.estrogen.utils.PlayerLookup;
import dev.mayaqq.estrogen.utils.Time;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;

public class EstrogenEffect
extends MobEffect {
    private static final UUID DASH_MODIFIER_UUID = UUID.fromString("2a2591c5-009f-4b24-97f2-b15f43415e4c");
    public short currentDashes = 0;
    public int dashCooldown = 0;
    public int groundCooldown = 0;
    public boolean onCooldown = false;
    private boolean shouldWaveDash = false;
    private BlockPos lastPos = null;

    public EstrogenEffect(MobEffectCategory statusEffectType, int color) {
        super(statusEffectType, color);
    }

    private static Boolean shouldRefreshDash(Player player) {
        return player.m_20096_() || player.m_9236_().m_8055_(player.m_20183_()).m_60734_() instanceof LiquidBlock;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!((Boolean)EstrogenConfig.server().dashEnabled.get()).booleanValue()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_ && player instanceof LocalPlayer) {
                --this.dashCooldown;
                --this.groundCooldown;
                if (this.dashCooldown < 0) {
                    this.dashCooldown = 0;
                }
                if (this.groundCooldown < 0) {
                    this.groundCooldown = 0;
                }
                if (this.dashCooldown > 0 && this.dashCooldown % 2 == 0 && entity.m_20183_() != this.lastPos) {
                    NetworkManager.sendToServer((ResourceLocation)EstrogenC2S.DASH_PARTICLES, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
                }
                this.lastPos = entity.m_20183_();
                Minecraft client = Minecraft.m_91087_();
                if (this.dashCooldown > 0 && this.shouldWaveDash && client.f_91066_.f_92089_.m_90857_()) {
                    player.m_20334_(player.m_20154_().f_82479_ * 3.0, 1.0, player.m_20154_().f_82481_ * 3.0);
                    this.shouldWaveDash = false;
                }
                if (EstrogenEffect.shouldRefreshDash(player).booleanValue() && this.groundCooldown == 0) {
                    this.groundCooldown = 4;
                    this.currentDashes = (short)player.m_21133_((Attribute)EstrogenAttributes.DASH_LEVEL.get());
                }
                Dash.onCooldown = this.onCooldown = this.dashCooldown > 0 || this.currentDashes == 0;
                if (EstrogenKeybinds.dashKey.m_90859_() && !this.onCooldown) {
                    if (player.m_146909_() > 50.0f && player.m_146909_() < 90.0f) {
                        this.shouldWaveDash = true;
                    }
                    this.dashCooldown = 10;
                    this.currentDashes = (short)(this.currentDashes - 1);
                    int dashDeltaModifier = (Integer)EstrogenConfig.server().dashDeltaModifier.get();
                    player.m_20334_(player.m_20154_().f_82479_ * (double)dashDeltaModifier, player.m_20154_().f_82480_ * (double)dashDeltaModifier, player.m_20154_().f_82481_ * (double)dashDeltaModifier);
                    NetworkManager.sendToServer((ResourceLocation)EstrogenC2S.DASH, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
                }
            }
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            new EstrogenStatusEffectSender().sendRemovePlayerStatusEffect(player, EstrogenEffects.ESTROGEN_EFFECT, (ServerPlayer[])PlayerLookup.tracking((Entity)player).toArray(ServerPlayer[]::new));
        }
        if (entity instanceof Player) {
            entity.m_21051_((Attribute)EstrogenAttributes.DASH_LEVEL.get()).m_22120_(DASH_MODIFIER_UUID);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (player.m_9236_().f_46443_ && player instanceof LocalPlayer) {
                this.resetDash(entity);
            }
        }
        if (!entity.m_21023_(EstrogenEffects.ESTROGEN_EFFECT) && entity instanceof Player) {
            entity.m_21051_((Attribute)EstrogenAttributes.BOOB_INITIAL_SIZE.get()).m_22100_(0.0);
            entity.m_21051_((Attribute)EstrogenAttributes.BOOB_GROWING_START_TIME.get()).m_22100_(-1.0);
        }
    }

    public void resetDash(LivingEntity entity) {
        this.currentDashes = 0;
        this.onCooldown = false;
        Dash.onCooldown = false;
        this.dashCooldown = 0;
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            new EstrogenStatusEffectSender().sendPlayerStatusEffect(player, EstrogenEffects.ESTROGEN_EFFECT, (ServerPlayer[])PlayerLookup.tracking((Entity)player).toArray(ServerPlayer[]::new));
        }
        super.m_6385_(entity, attributes, amplifier);
        AttributeModifier dashModifier = new AttributeModifier(DASH_MODIFIER_UUID, "Dash Level", (double)(amplifier + 1), AttributeModifier.Operation.ADDITION);
        entity.m_21051_((Attribute)EstrogenAttributes.DASH_LEVEL.get()).m_22120_(DASH_MODIFIER_UUID);
        entity.m_21051_((Attribute)EstrogenAttributes.DASH_LEVEL.get()).m_22125_(dashModifier);
        AttributeInstance startTime = entity.m_21051_((Attribute)EstrogenAttributes.BOOB_GROWING_START_TIME.get());
        if (startTime != null && startTime.m_22115_() < 0.0) {
            double currentTime = Time.currentTime(entity.m_9236_());
            entity.m_21051_((Attribute)EstrogenAttributes.BOOB_GROWING_START_TIME.get()).m_22100_(currentTime);
        }
    }
}

