/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.config;

import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class EstrogenConfig {
    public static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static Client client;
    private static Common common;
    private static Server server;

    public static Client client() {
        return client;
    }

    public static Common common() {
        return common;
    }

    public static Server server() {
        return server;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        client = EstrogenConfig.register(Client::new, ModConfig.Type.CLIENT);
        common = EstrogenConfig.register(Common::new, ModConfig.Type.COMMON);
        server = EstrogenConfig.register(Server::new, ModConfig.Type.SERVER);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    public static class Client
    extends ConfigBase {
        public final ConfigBase.ConfigGroup chest = this.group(1, "chest", new String[]{"Settings for the chest feature"});
        public final ConfigBase.ConfigBool chestFeature = this.b(true, "chestFeature", new String[]{"Enable chest feature"});
        public final ConfigBase.ConfigBool chestArmor = this.b(true, "chestArmor", new String[]{"Enable chest feature armor"});
        public final ConfigBase.ConfigGroup ui = this.group(1, "ui", new String[]{"UI element Configuration"});
        public final ConfigBase.ConfigBool dashOverlay = this.b(true, "dashOverlay", new String[]{"Enable dash overlay"});
        public final ConfigBase.ConfigGroup compat = this.group(1, "compat", new String[]{"Compatibility between other mods settings"});
        public final ConfigBase.ConfigBool ears = this.b(true, "ears", new String[]{"Enable ears Compatibility"});
        public final ConfigBase.ConfigBool figura = this.b(true, "figura", new String[]{"Enable figura Compatibility"});

        public String getName() {
            return "client";
        }
    }

    public static class Common
    extends ConfigBase {
        public final ConfigBase.ConfigGroup estrogenPatches = this.group(1, "estrogenPatches", new String[]{"Settings for the estrogen patches"});
        public final ConfigBase.ConfigInt estrogenPatchesStackSize = this.i(4, 1, 64, "estrogenPatchesStackSize", new String[]{"\u00a74THIS ONLY WORKS ON \u00a7fFABRIC\u00a77/\u00a7dQUILT\u00a74 MOD LOADER", "The stack size limit of estrogen patches", ConfigAnnotations.RequiresRestart.BOTH.asComment()});
        public final ConfigBase.ConfigGroup minigame = this.group(1, "minigame", new String[]{"Settings which are more fun and not fit for survival"});
        public final ConfigBase.ConfigBool minigameEnabled = this.b(false, "minigameEnabled", new String[]{"Enable/Disable all minigame settings"});
        public final ConfigBase.ConfigBool permaDash = this.b(true, "permaDash", new String[]{"Gives you permanent, unremovable Girl Power Effect"});
        public final ConfigBase.ConfigInt girlPowerLevel = this.i(0, 0, 255, "permaDashAmount", new String[]{"The level of Girl Power Effect when Perma-Dash is enabled"});

        public String getName() {
            return "common";
        }
    }

    public static class Server
    extends ConfigBase {
        public final ConfigBase.ConfigGroup dash = this.group(1, "dash", new String[]{"Settings for the dash effect"});
        public final ConfigBase.ConfigBool dashEnabled = this.b(true, "dashEnabled", new String[]{"Enable dash from the Effect of Estrogen"});
        public final ConfigBase.ConfigInt dashDeltaModifier = this.i(2, 0, 100, "dashDeltaModifier", new String[]{"The multiplier for the dash delta movement"});
        public final ConfigBase.ConfigGroup centrifuge = this.group(1, "centrifuge", new String[]{"Settings for the centrifuge"});
        public final ConfigBase.ConfigFloat centrifugeSpeedRequired = this.f(256.0f, 0.0f, 256.0f, "centrifugeSpeedRequired", new String[]{"Minimum speed required for the centrifuge to work", ConfigAnnotations.RequiresRestart.BOTH.asComment()});

        public String getName() {
            return "server";
        }
    }
}

