/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManager {
    public static final LevelResource DATA_DIR = new LevelResource("ftbchunks");
    private static final Long2ObjectMap<UUID> EMPTY_CHUNKS = Long2ObjectMaps.emptyMap();
    private final TeamManager teamManager;
    private final Map<UUID, FTBChunksTeamData> teamData;
    private final Map<ChunkDimPos, ClaimedChunk> claimedChunks;
    private final Path dataDirectory;
    private Map<ResourceKey<Level>, Long2ObjectMap<UUID>> forceLoadedChunkCache;

    public ClaimedChunkManager(TeamManager m) {
        this.teamManager = m;
        this.teamData = new HashMap<UUID, FTBChunksTeamData>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunk>();
        this.dataDirectory = this.getMinecraftServer().m_129843_(DATA_DIR);
        Path localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(localDirectory, new LinkOption[0])) {
                Files.createDirectories(localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initForceLoadedChunks(ServerLevel level) {
        Long2ObjectMap<UUID> map = this.getForceLoadedChunks((ResourceKey<Level>)level.m_46472_());
        if (map.isEmpty() || level.m_7726_() == null) {
            return;
        }
        map.forEach((pos, id) -> {
            ChunkPos chunkPos = new ChunkPos(pos.longValue());
            FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", id, chunkPos.f_45578_, chunkPos.f_45579_, true);
        });
        level.m_7726_().m_8419_(false);
        FTBChunks.LOGGER.info("Force-loaded %d chunks in %s".formatted(map.size(), level.m_46472_().m_135782_()));
    }

    private FTBChunksTeamData loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(team.getId() + ".snbt");
        FTBChunksTeamData data = new FTBChunksTeamData(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((CompoundTag)dataFile);
            this.teamData.put(team.getId(), data);
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.server;
    }

    public FTBChunksTeamData getData(@Nullable Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found!");
        }
        FTBChunksTeamData data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    public FTBChunksTeamData getPersonalData(UUID id) {
        PlayerTeam team = FTBTeamsAPI.getManager().getInternalPlayerTeam(id);
        return team == null ? null : this.getData((Team)team);
    }

    public FTBChunksTeamData getPersonalData(ServerPlayer player) {
        return this.getPersonalData(player.m_20148_());
    }

    public FTBChunksTeamData getData(ServerPlayer player) {
        return this.getData(FTBTeamsAPI.getPlayerTeam((ServerPlayer)player));
    }

    public boolean hasData(ServerPlayer player) {
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(player.m_20148_());
        return team != null && this.teamData.containsKey(team.getId());
    }

    public void deleteTeam(Team toDelete) {
        FTBChunksTeamData data = this.teamData.get(toDelete.getId());
        if (data != null && toDelete.getMembers().isEmpty()) {
            FTBChunks.LOGGER.debug("dropping references to empty team " + toDelete.getId());
            this.teamData.remove(toDelete.getId());
            try {
                Files.deleteIfExists(data.file);
            }
            catch (IOException e) {
                FTBChunks.LOGGER.error(String.format("can't delete file %s: %s", data.file, e.getMessage()));
            }
        }
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }

    public Map<UUID, List<ClaimedChunk>> getClaimedChunksByTeam(Predicate<ClaimedChunk> predicate) {
        return this.getAllClaimedChunks().stream().filter(predicate).collect(Collectors.groupingBy(cc -> cc.teamData.getTeamId()));
    }

    public boolean getBypassProtection(UUID player) {
        PlayerTeam team = this.teamManager.getInternalPlayerTeam(player);
        return team != null && team.getExtraData().m_128471_("BypassFTBChunksProtection");
    }

    public void setBypassProtection(UUID player, boolean bypass) {
        PlayerTeam team = this.teamManager.getInternalPlayerTeam(player);
        if (team != null) {
            team.getExtraData().m_128379_("BypassFTBChunksProtection", bypass);
            team.save();
        }
    }

    public boolean protect(@Nullable Entity entity, InteractionHand hand, BlockPos pos, Protection protection, @Nullable Entity targetEntity) {
        ServerPlayer player;
        block10: {
            block9: {
                if (!(entity instanceof ServerPlayer)) break block9;
                player = (ServerPlayer)entity;
                if (!((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue() && player.f_19853_ != null) break block10;
            }
            return false;
        }
        boolean isFake = PlayerHooks.isFake((Player)player);
        if (isFake && ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).getProtect();
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(player.f_19853_, pos));
        if (chunk != null) {
            ProtectionOverride override = protection.override(player, pos, hand, chunk, targetEntity);
            if (override.isOverride()) {
                return override.getProtect();
            }
            return !player.m_5833_() && (isFake || !this.getBypassProtection(player.m_20148_()));
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionOverride override = protection.override(player, pos, hand, null, targetEntity);
            if (override.isOverride()) {
                return override.getProtect();
            }
            if (!isFake && (this.getBypassProtection(player.m_20148_()) || player.m_5833_())) {
                return false;
            }
            player.m_5661_((Component)Component.m_237113_((String)"You need to claim this chunk to interact with blocks here!"), true);
            return true;
        }
        return false;
    }

    public void clearForceLoadedCache() {
        this.forceLoadedChunkCache = null;
    }

    public Map<ResourceKey<Level>, Long2ObjectMap<UUID>> getForceLoadedChunks() {
        if (this.forceLoadedChunkCache == null) {
            this.forceLoadedChunkCache = new HashMap<ResourceKey<Level>, Long2ObjectMap<UUID>>();
            for (ClaimedChunk chunk : this.getAllClaimedChunks()) {
                if (!chunk.isActuallyForceLoaded()) continue;
                Long2ObjectMap pos2idMap = this.forceLoadedChunkCache.computeIfAbsent((ResourceKey<Level>)chunk.pos.dimension, k -> new Long2ObjectOpenHashMap());
                pos2idMap.put(ChunkPos.m_45589_((int)chunk.pos.x, (int)chunk.pos.z), (Object)chunk.teamData.getTeamId());
            }
            this.forceLoadedChunkCache = this.forceLoadedChunkCache.isEmpty() ? Collections.emptyMap() : this.forceLoadedChunkCache;
        }
        return this.forceLoadedChunkCache;
    }

    @Nonnull
    public Long2ObjectMap<UUID> getForceLoadedChunks(ResourceKey<Level> dimension) {
        return this.getForceLoadedChunks().getOrDefault(dimension, EMPTY_CHUNKS);
    }

    public boolean isChunkForceLoaded(ResourceKey<Level> dimension, int x, int z) {
        return this.getForceLoadedChunks(dimension).containsKey(ChunkPos.m_45589_((int)x, (int)z));
    }

    public void registerClaim(ChunkDimPos pos, ClaimedChunk chunk) {
        this.claimedChunks.put(pos, chunk);
    }

    public void unregisterClaim(ChunkDimPos pos) {
        this.claimedChunks.remove(pos);
    }
}

