/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.integration.RefreshMinimapIconsEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WaypointManager
implements Iterable<Waypoint> {
    private static final String WAYPOINTS_FILE = "waypoints.json";
    private final Set<Waypoint> waypoints = new HashSet<Waypoint>();
    private final Set<Waypoint> deathpoints = new HashSet<Waypoint>();
    private final MapDimension mapDimension;

    public WaypointManager(MapDimension mapDimension) {
        this.mapDimension = mapDimension;
    }

    public static WaypointManager fromJson(MapDimension mapDimension) {
        WaypointManager manager;
        block14: {
            Path file = mapDimension.directory.resolve(WAYPOINTS_FILE);
            manager = new WaypointManager(mapDimension);
            if (Files.exists(file, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    JsonObject json = (JsonObject)FTBChunks.GSON.fromJson((Reader)reader, JsonObject.class);
                    if (!json.has("waypoints")) break block14;
                    for (JsonElement e : json.get("waypoints").getAsJsonArray()) {
                        JsonObject o = e.getAsJsonObject();
                        Waypoint wp = new Waypoint(mapDimension, o.get("x").getAsInt(), o.get("y").getAsInt(), o.get("z").getAsInt());
                        wp.hidden = o.get("hidden").getAsBoolean();
                        wp.name = o.get("name").getAsString();
                        wp.color = 0xFFFFFF;
                        if (o.has("color")) {
                            try {
                                wp.color = Integer.decode(o.get("color").getAsString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (o.has("type")) {
                            wp.type = WaypointType.TYPES.getOrDefault(o.get("type").getAsString(), WaypointType.DEFAULT);
                        }
                        manager.add(wp);
                        wp.update();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return manager;
    }

    public static void writeJson(MapDimension mapDimension, List<Waypoint> waypoints) throws IOException {
        JsonObject json = new JsonObject();
        JsonArray waypointArray = new JsonArray();
        for (Waypoint w : waypoints) {
            JsonObject o = new JsonObject();
            o.addProperty("hidden", Boolean.valueOf(w.hidden));
            o.addProperty("name", w.name);
            o.addProperty("x", (Number)w.x);
            o.addProperty("y", (Number)w.y);
            o.addProperty("z", (Number)w.z);
            o.addProperty("color", String.format("#%06X", 0xFFFFFF & w.color));
            o.addProperty("type", w.type.id);
            waypointArray.add((JsonElement)o);
        }
        json.add("waypoints", (JsonElement)waypointArray);
        try (BufferedWriter writer = Files.newBufferedWriter(mapDimension.directory.resolve(WAYPOINTS_FILE), new OpenOption[0]);){
            FTBChunks.GSON.toJson((JsonElement)json, (Appendable)writer);
        }
    }

    public void add(Waypoint waypoint) {
        this.waypoints.add(waypoint);
        if (waypoint.type == WaypointType.DEATH) {
            this.deathpoints.add(waypoint);
        }
        waypoint.update();
        this.mapDimension.saveData = true;
        RefreshMinimapIconsEvent.trigger();
    }

    public void remove(Waypoint waypoint) {
        this.waypoints.remove(waypoint);
        if (waypoint.type == WaypointType.DEATH) {
            this.deathpoints.remove(waypoint);
        }
        this.mapDimension.saveData = true;
        RefreshMinimapIconsEvent.trigger();
    }

    public boolean removeIf(Predicate<Waypoint> predicate) {
        if (this.waypoints.removeIf(predicate)) {
            this.deathpoints.clear();
            this.deathpoints.addAll(this.waypoints.stream().filter(w -> w.type == WaypointType.DEATH).toList());
            this.mapDimension.saveData = true;
            RefreshMinimapIconsEvent.trigger();
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.waypoints.isEmpty();
    }

    public Optional<Waypoint> getNearestDeathpoint(Player p) {
        return this.deathpoints.isEmpty() ? Optional.empty() : this.deathpoints.stream().min(Comparator.comparingDouble(o -> p.m_20275_((double)o.x, (double)o.y, (double)o.z)));
    }

    @Override
    @NotNull
    public Iterator<Waypoint> iterator() {
        return this.waypoints.iterator();
    }

    public boolean hasDeathpoint() {
        return !this.deathpoints.isEmpty();
    }

    public Stream<Waypoint> stream() {
        return this.waypoints.stream();
    }
}

