/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class MapIOUtils {
    public static void write(OutputStream stream, IOCallback<DataOutputStream> callback) {
        try (DataOutputStream s = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(stream)));){
            callback.callback(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void write(Path path, IOCallback<DataOutputStream> callback) {
        try (OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);){
            MapIOUtils.write(fos, callback);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean read(Path path, IOCallback<DataInputStream> callback) {
        boolean bl;
        if (Files.notExists(path, new LinkOption[0]) || !Files.isReadable(path)) {
            return false;
        }
        DataInputStream in2 = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(path, new OpenOption[0]))));
        try {
            callback.callback(in2);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception in2) {
                boolean bl2;
                DataInputStream in3 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]))));
                try {
                    callback.callback(in3);
                    bl2 = false;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            in3.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                in3.close();
                return bl2;
            }
        }
        in2.close();
        return bl;
    }

    public static interface IOCallback<T> {
        public void callback(T var1) throws IOException;
    }
}

