/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WaypointEditorScreen
extends BaseScreen {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba((int)-1724697805);
    private static final Icon PEARL_ICON = ImageIcon.getIcon((ResourceLocation)new ResourceLocation("minecraft", "textures/item/ender_pearl.png"));
    public static Theme THEME = new Theme(){

        public void drawScrollBarBackground(PoseStack matrixStack, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(matrixStack, x, y, w, h);
        }

        public void drawScrollBar(PoseStack matrixStack, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(matrixStack, x, y, w, h);
        }
    };
    private static final Component TITLE = Component.m_237115_((String)"ftbchunks.gui.waypoints").m_130940_(ChatFormatting.BOLD);
    private final Panel waypointPanel = new WaypointPanel((Panel)this);
    private final PanelScrollBar scrollbar = new PanelScrollBar((Panel)this, this.waypointPanel){

        public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.getMaxValue() > (double)this.parent.height) {
                super.drawBackground(matrixStack, theme, x, y, w, h);
            }
        }
    };
    private final List<Widget> rows = new ArrayList<Widget>();
    private final Button buttonCollapseAll = new ExpanderButton((Panel)this, false);
    private final Button buttonExpandAll = new ExpanderButton((Panel)this, true);
    private int maxWidth;

    public WaypointEditorScreen() {
        for (DimWayPoints entry : this.collectWaypoints()) {
            this.rows.add((Widget)new VerticalSpaceWidget(this.waypointPanel, 4));
            boolean thisDimension = Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)entry.levelKey);
            GroupButton groupButton = new GroupButton(this.waypointPanel, (Component)Component.m_237113_((String)entry.levelKey.toString()).m_130940_(ChatFormatting.YELLOW), !thisDimension);
            this.rows.add((Widget)groupButton);
            for (Waypoint wp : entry.waypoints) {
                this.rows.add((Widget)new RowPanel(this.waypointPanel, groupButton, wp));
            }
        }
    }

    private List<DimWayPoints> collectWaypoints() {
        ArrayList<DimWayPoints> res = new ArrayList<DimWayPoints>();
        MapManager.inst.getDimensions().keySet().stream().filter(dim -> !MapManager.inst.getDimension((ResourceKey<Level>)dim).getWaypointManager().isEmpty()).sorted((dim1, dim2) -> {
            if (dim1.m_135782_().m_135827_().equals("minecraft") && !dim2.m_135782_().m_135827_().equals("minecraft")) {
                return -1;
            }
            int i = dim1.m_135782_().m_135827_().compareTo(dim2.m_135782_().m_135827_());
            return i == 0 ? dim1.m_135782_().m_135815_().compareTo(dim2.m_135782_().m_135815_()) : i;
        }).forEach(dim -> res.add(new DimWayPoints(dim.m_135782_(), MapManager.inst.getDimension((ResourceKey<Level>)dim).getWaypointManager().stream().sorted(Comparator.comparingDouble(o -> Minecraft.m_91087_().f_91074_.m_20275_((double)o.x, (double)o.y, (double)o.z))).toList())));
        return res;
    }

    public boolean onInit() {
        boolean r = this.setFullscreen();
        this.maxWidth = Math.min(this.maxWidth, this.getGui().width / 2);
        return r;
    }

    public void addWidgets() {
        this.add((Widget)this.waypointPanel);
        this.add((Widget)this.scrollbar);
        this.add((Widget)this.buttonCollapseAll);
        this.add((Widget)this.buttonExpandAll);
    }

    public void alignWidgets() {
        this.waypointPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.waypointPanel.alignWidgets();
        this.scrollbar.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonExpandAll.setPos(this.width - 18, 2);
        this.buttonCollapseAll.setPos(this.width - 38, 2);
    }

    public Theme getTheme() {
        return THEME;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(matrixStack, 0, 0, w, 20);
        theme.drawString(matrixStack, (Object)this.getTitle(), 6, 6, 2);
    }

    public boolean keyPressed(Key key) {
        if (key.esc() && this.contextMenu != null) {
            this.closeContextMenu();
            return true;
        }
        return super.keyPressed(key);
    }

    private class WaypointPanel
    extends Panel {
        public WaypointPanel(Panel panel) {
            super(panel);
        }

        public void addWidgets() {
            WaypointEditorScreen.this.maxWidth = 0;
            for (Widget row : WaypointEditorScreen.this.rows) {
                if (row instanceof RowPanel) {
                    RowPanel rowPanel = (RowPanel)row;
                    if (rowPanel.groupButton.collapsed || rowPanel.deleted) continue;
                }
                this.add(row);
                if (!(row instanceof RowPanel)) continue;
                RowPanel rp = (RowPanel)row;
                WaypointEditorScreen.this.maxWidth = Math.max(WaypointEditorScreen.this.maxWidth, WaypointEditorScreen.this.getTheme().getStringWidth(rp.wp.name));
            }
            WaypointEditorScreen.this.maxWidth = Math.min(WaypointEditorScreen.this.maxWidth, this.getGui().width / 2);
        }

        public void alignWidgets() {
            WaypointEditorScreen.this.scrollbar.setMaxValue((double)this.align(WidgetLayout.VERTICAL));
            int sbWidth = WaypointEditorScreen.this.scrollbar.getMaxValue() > 0.0 ? 16 : 0;
            WaypointEditorScreen.this.scrollbar.setWidth(sbWidth);
            this.widgets.forEach(w -> {
                int prevWidth = w.width;
                w.setWidth(this.width - sbWidth);
                if (w.width != prevWidth && w instanceof Panel) {
                    Panel p = (Panel)w;
                    p.alignWidgets();
                }
            });
        }
    }

    private class ExpanderButton
    extends SimpleButton {
        public ExpanderButton(Panel panel, boolean expand) {
            super(panel, (Component)Component.m_237115_((String)(expand ? "gui.expand_all" : "gui.collapse_all")), expand ? Icons.DOWN : Icons.UP, (btn, mb) -> {
                dev$ftb$mods$ftbchunks$client$WaypointEditorScreen$this.rows.stream().filter(w -> w instanceof GroupButton).map(w -> (GroupButton)((Object)((Object)w))).forEach(g -> g.setCollapsed(!expand));
                dev$ftb$mods$ftbchunks$client$WaypointEditorScreen$this.scrollbar.setValue(0.0);
                btn.getGui().refreshWidgets();
            });
        }
    }

    private record DimWayPoints(ResourceLocation levelKey, List<Waypoint> waypoints) {
    }

    private static class GroupButton
    extends Button {
        private boolean collapsed;
        private final Component titleText;

        public GroupButton(Panel panel, Component titleText, boolean startCollapsed) {
            super(panel);
            this.titleText = titleText;
            this.setCollapsed(startCollapsed);
        }

        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }

        void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            this.setTitle((Component)Component.m_237113_((String)(collapsed ? "[>] " : "[v] ")).m_130940_(collapsed ? ChatFormatting.RED : ChatFormatting.GREEN).m_7220_(this.titleText));
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(matrixStack, x, y, w, h);
            theme.drawString(matrixStack, (Object)this.getTitle(), x + 3, y + 1 + (h - theme.getFontHeight()) / 2);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color4I.GRAY.withAlpha(80).draw(matrixStack, 0, y, this.width, 1);
            Color4I.GRAY.withAlpha(80).draw(matrixStack, 0, y, 1, this.height);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
        }

        public void addMouseOverText(TooltipList list) {
        }
    }

    private class RowPanel
    extends Panel {
        private final GroupButton groupButton;
        private final Waypoint wp;
        private boolean deleted;

        public RowPanel(Panel panel, GroupButton groupButton, Waypoint wp) {
            super(panel);
            this.deleted = false;
            this.groupButton = groupButton;
            this.wp = wp;
            this.setHeight(18);
        }

        public void addWidgets() {
            this.add((Widget)new SimpleButton((Panel)this, (Component)Component.m_237119_(), this.wp.hidden ? Icons.REMOVE_GRAY : Icons.ACCEPT, (w, mb) -> {
                this.wp.hidden = !this.wp.hidden;
                this.wp.dimension.saveData = true;
                w.setIcon(this.wp.hidden ? Icons.REMOVE_GRAY : Icons.ACCEPT);
            }));
            this.add((Widget)new TextField((Panel)this).setMaxWidth(WaypointEditorScreen.this.maxWidth).setTrim().setText(this.wp.name).setColor(Color4I.rgb((int)this.wp.color)).addFlags(2));
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            String distStr = player.f_19853_.m_46472_().equals(this.wp.dimension.dimension) ? String.format("%.1fm", Math.sqrt(player.m_20275_((double)this.wp.x, (double)this.wp.y, (double)this.wp.z))) : "";
            this.add((Widget)new TextField((Panel)this).setText(distStr).setColor(Color4I.GRAY));
        }

        public void alignWidgets() {
            if (this.widgets.size() == 3) {
                int yOff = (this.height - WaypointEditorScreen.this.getTheme().getFontHeight()) / 2 + 1;
                ((Widget)this.widgets.get(0)).setPos(10, 1);
                ((Widget)this.widgets.get(1)).setPos(30, yOff);
                ((Widget)this.widgets.get(2)).setPos(WaypointEditorScreen.this.maxWidth + 40, yOff);
            }
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            super.draw(matrixStack, theme, x, y, w, h);
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && button.isRight()) {
                ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
                list.add(new ContextMenuItem((Component)Component.m_237113_((String)this.wp.name), this.wp.type.icon.withTint(Color4I.rgb((int)this.wp.color)), null));
                list.add(ContextMenuItem.SEPARATOR);
                list.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.rename"), Icons.CHAT, () -> {
                    StringConfig config = new StringConfig();
                    config.defaultValue = "";
                    config.value = this.wp.name;
                    config.onClicked(MouseButton.LEFT, accepted -> {
                        if (accepted) {
                            this.wp.name = (String)config.value;
                            this.wp.dimension.saveData = true;
                        }
                        this.openGui();
                    });
                }));
                if (this.wp.type.canChangeColor) {
                    list.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbchunks.gui.change_color"), Icons.COLOR_RGB, () -> {
                        int r = this.wp.color >> 16 & 0xFF;
                        int g = this.wp.color >> 8 & 0xFF;
                        int b = this.wp.color >> 0 & 0xFF;
                        float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
                        float add = RowPanel.isShiftKeyDown() ? -0.083333336f : 0.083333336f;
                        Color4I col = Color4I.hsb((float)(hsb[0] + add), (float)hsb[1], (float)hsb[2]);
                        this.wp.color = col.rgba();
                        this.wp.dimension.saveData = true;
                        this.wp.update();
                        Object patt12074$temp = this.widgets.get(1);
                        if (patt12074$temp instanceof TextField) {
                            TextField tf = (TextField)patt12074$temp;
                            tf.setColor(Color4I.rgb((int)this.wp.color));
                        }
                        ((ContextMenuItem)list.get((int)0)).icon = this.wp.type.icon.withColor(Color4I.rgb((int)this.wp.color));
                    }).setCloseMenu(false));
                }
                if (Minecraft.m_91087_().f_91074_.m_20310_(2)) {
                    list.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbchunks.gui.teleport"), PEARL_ICON, () -> {
                        new TeleportFromMapPacket(this.wp.x, this.wp.y + 1, this.wp.z, false, this.wp.dimension.dimension).sendToServer();
                        this.closeGui(false);
                    }));
                }
                list.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.remove"), Icons.REMOVE, () -> this.getGui().openYesNo((Component)Component.m_237110_((String)"ftbchunks.gui.delete_waypoint", (Object[])new Object[]{Component.m_237113_((String)this.wp.name).m_130948_(Style.f_131099_.m_178520_(this.wp.color))}), (Component)Component.m_237119_(), () -> {
                    MapManager.inst.getDimension(this.wp.dimension.dimension).getWaypointManager().remove(this.wp);
                    this.wp.dimension.saveData = true;
                    this.deleted = true;
                    this.getGui().refreshWidgets();
                })));
                this.getGui().openContextMenu(list);
                return true;
            }
            return super.mousePressed(button);
        }
    }
}

