/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.compat.jei;

import com.horriblenerd.cobblegenrandomizer.CobbleGenRandomizer;
import com.horriblenerd.cobblegenrandomizer.util.Generator;
import com.horriblenerd.cobblegenrandomizer.util.WeightedBlock;
import com.horriblenerd.compat.jei.GeneratorRecipeCategory;
import com.horriblenerd.compat.jei.GeneratorRecipeWrapper;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class CobbleGenRandomizerJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("cobblegenrandomizer", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registration) {
        GeneratorRecipeCategory cobblestone_generator = new GeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper(), Items.f_42594_, I18n.m_118938_((String)"cobblegenrandomizer.jei.cobbleCategory", (Object[])new Object[0]), new ResourceLocation("cobblegenrandomizer", "cobble_gen"), 0);
        GeneratorRecipeCategory stone_generator = new GeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper(), Items.f_41905_, I18n.m_118938_((String)"cobblegenrandomizer.jei.stoneCategory", (Object[])new Object[0]), new ResourceLocation("cobblegenrandomizer", "stone_gen"), 1);
        GeneratorRecipeCategory basalt_generator = new GeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper(), Items.f_42051_, I18n.m_118938_((String)"cobblegenrandomizer.jei.basaltCategory", (Object[])new Object[0]), new ResourceLocation("cobblegenrandomizer", "basalt_gen"), 1);
        ItemStack custom_icon = new ItemStack((ItemLike)Items.f_42594_);
        custom_icon.m_41663_(Enchantments.f_44987_, 0);
        GeneratorRecipeCategory custom_generator = new GeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper(), custom_icon, I18n.m_118938_((String)"cobblegenrandomizer.jei.customCategory", (Object[])new Object[0]), new ResourceLocation("cobblegenrandomizer", "custom_gen"), 2);
        registration.addRecipeCategories(new IRecipeCategory[]{cobblestone_generator});
        registration.addRecipeCategories(new IRecipeCategory[]{stone_generator});
        registration.addRecipeCategories(new IRecipeCategory[]{basalt_generator});
        registration.addRecipeCategories(new IRecipeCategory[]{custom_generator});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List cobbleRecipes = CobbleGenRandomizer.GENERATORS.COBBLE_LIST.stream().map(b -> new GeneratorRecipeWrapper((WeightedBlock)((Object)b), Generator.Type.COBBLESTONE, Blocks.f_50016_)).sorted().collect(Collectors.toList());
        registration.addRecipes(new RecipeType(new ResourceLocation("cobblegenrandomizer", "cobble_gen"), GeneratorRecipeWrapper.class), cobbleRecipes);
        List stoneRecipes = CobbleGenRandomizer.GENERATORS.STONE_LIST.stream().map(b -> new GeneratorRecipeWrapper((WeightedBlock)((Object)b), Generator.Type.STONE, Blocks.f_50016_)).sorted().collect(Collectors.toList());
        registration.addRecipes(new RecipeType(new ResourceLocation("cobblegenrandomizer", "stone_gen"), GeneratorRecipeWrapper.class), stoneRecipes);
        List basaltRecipes = CobbleGenRandomizer.GENERATORS.BASALT_LIST.stream().map(b -> new GeneratorRecipeWrapper((WeightedBlock)((Object)b), Generator.Type.BASALT, Blocks.f_50016_)).sorted().collect(Collectors.toList());
        registration.addRecipes(new RecipeType(new ResourceLocation("cobblegenrandomizer", "basalt_gen"), GeneratorRecipeWrapper.class), basaltRecipes);
        for (Generator gen : CobbleGenRandomizer.GENERATORS.CUSTOM_GENERATOR_LIST) {
            List customRecipes = gen.getBlockList().stream().map(b -> new GeneratorRecipeWrapper((WeightedBlock)((Object)b), gen.getType(), gen.getBlock())).sorted().collect(Collectors.toList());
            registration.addRecipes(new RecipeType(new ResourceLocation("cobblegenrandomizer", "custom_gen"), GeneratorRecipeWrapper.class), customRecipes);
        }
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

