/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.BiplaneEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;

public class BiplaneEntityRenderer<T extends BiplaneEntity>
extends AircraftEntityRenderer<T> {
    private static final ResourceLocation id = Main.locate("objects/biplane.obj");
    private final ResourceLocation texture;
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<ItemStack> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (ItemStack slot : slots) {
            if (slot.m_41619_() || !(slot.m_41720_() instanceof BannerItem)) continue;
            List<Pair<Holder<BannerPattern>, DyeColor>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = BiplaneEntityRenderer.getFaces(id, "banner_" + i++);
            BiplaneEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(0.0, 0.3125, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)entity.engineRotation.getSmooth(tickDelta) * 100.0)));
        matrixStack.m_85837_(0.0, -0.3125, 0.0);
    })).add(new AircraftEntityRenderer.Object(id, "elevator").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(0.0, 0.0625, -2.5);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-entity.pressingInterpolatedZ.getSmooth(tickDelta) * 20.0f));
        matrixStack.m_85837_(0.0, -0.0625, 2.5);
    })).add(new AircraftEntityRenderer.Object(id, "rudder").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(0.0, 0.0625, -2.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(entity.pressingInterpolatedX.getSmooth(tickDelta) * 18.0f));
        matrixStack.m_85837_(0.0, -0.0625, 2.5);
    }));

    public BiplaneEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.texture = Main.locate("textures/entity/biplane.png");
    }

    @Override
    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        super.render(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTexture(T AircraftEntity2) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.4f, 0.05f);
    }
}

