/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.OperationAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.lib.peripherals.BoundMethod;
import de.srendi.advancedperipherals.lib.peripherals.IBasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralCheck;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePeripheral<O extends IPeripheralOwner>
implements IBasePeripheral<O>,
IDynamicPeripheral {
    protected final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    protected final String type;
    protected final O owner;
    protected final List<BoundMethod> pluggedMethods = new ArrayList<BoundMethod>();
    protected boolean initialized = false;
    protected List<IPeripheralPlugin> plugins = null;
    protected String[] methodNames = new String[0];

    protected BasePeripheral(String type, O owner) {
        this.type = type;
        this.owner = owner;
    }

    protected void buildPlugins() {
        if (!this.initialized) {
            this.initialized = true;
            this.pluggedMethods.clear();
            if (this.plugins != null) {
                this.plugins.forEach(plugin -> {
                    if (plugin.isSuitable(this)) {
                        this.pluggedMethods.addAll(plugin.getMethods());
                    }
                });
            }
            this.owner.getAbilities().forEach(ability -> {
                if (ability instanceof IPeripheralPlugin) {
                    IPeripheralPlugin peripheralPlugin = (IPeripheralPlugin)((Object)ability);
                    this.pluggedMethods.addAll(peripheralPlugin.getMethods());
                }
            });
            this.methodNames = (String[])this.pluggedMethods.stream().map(BoundMethod::getName).toArray(String[]::new);
        }
    }

    protected void addPlugin(@NotNull IPeripheralPlugin plugin) {
        if (this.plugins == null) {
            this.plugins = new LinkedList<IPeripheralPlugin>();
        }
        this.plugins.add(plugin);
        IPeripheralOperation<?>[] operations = plugin.getOperations();
        if (operations != null) {
            OperationAbility operationAbility = this.owner.getAbility(PeripheralOwnerAbility.OPERATION);
            if (operationAbility == null) {
                throw new IllegalArgumentException("This is not possible to attach plugin with operations to not operationable owner");
            }
            for (IPeripheralOperation<?> operation : operations) {
                operationAbility.registerOperation(operation);
            }
        }
    }

    @Override
    public List<IComputerAccess> getConnectedComputers() {
        return this.connectedComputers;
    }

    @Nullable
    public Object getTarget() {
        return this.owner;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public void attach(@NotNull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return Objects.equals(this, iPeripheral);
    }

    @Override
    public O getPeripheralOwner() {
        return this.owner;
    }

    @LuaFunction
    public final String getName() {
        return this.owner.getCustomName();
    }

    public Map<String, Object> getPeripheralConfiguration() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.owner.getAbilities().forEach(ability -> ability.collectConfiguration(data));
        return data;
    }

    @LuaFunction
    public final Map<String, Object> getConfiguration() {
        return this.getPeripheralConfiguration();
    }

    protected BlockPos getPos() {
        return this.owner.getPos();
    }

    protected Level getLevel() {
        return this.owner.getLevel();
    }

    protected Direction validateSide(String direction) throws LuaException {
        return CoordUtil.getDirection(this.owner.getOrientation(), direction);
    }

    @NotNull
    public @NotNull String @NotNull [] getMethodNames() {
        if (!this.initialized) {
            this.buildPlugins();
        }
        return this.methodNames;
    }

    @NotNull
    public MethodResult callMethod(@NotNull IComputerAccess access, @NotNull ILuaContext context, int index, @NotNull IArguments arguments) throws LuaException {
        if (!this.initialized) {
            this.buildPlugins();
        }
        return this.pluggedMethods.get(index).apply(access, context, arguments);
    }

    protected <T> MethodResult withOperation(IPeripheralOperation<T> operation, T context, @Nullable IPeripheralCheck<T> check, IPeripheralFunction<T, MethodResult> method, @Nullable Consumer<T> successCallback) throws LuaException {
        return this.withOperation(operation, context, check, method, successCallback, null);
    }

    protected <T> MethodResult withOperation(IPeripheralOperation<T> operation, T context, @Nullable IPeripheralCheck<T> check, IPeripheralFunction<T, MethodResult> method, @Nullable Consumer<T> successCallback, @Nullable BiConsumer<MethodResult, OperationAbility.FailReason> failCallback) throws LuaException {
        OperationAbility operationAbility = this.owner.getAbility(PeripheralOwnerAbility.OPERATION);
        if (operationAbility == null) {
            throw new IllegalArgumentException("This shouldn't happen at all");
        }
        return operationAbility.performOperation(operation, context, check, method, successCallback, failCallback);
    }
}

