/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.mixin.common.block;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.block.CarvedBarrelCactusBlock;

@Mixin(value={PointedDripstoneBlock.class})
public class MixinPointedDripstoneBlock {
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    @Shadow
    private static boolean m_202017_(BlockGetter block, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(block, pos)) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape shape = state.m_60812_(block, pos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82689_);
    }

    @Inject(method={"findFillableCauldronBelowStalactiteTip"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addBYGCauldron(Level world, BlockPos pos, Fluid fluid, CallbackInfoReturnable<BlockPos> cir) {
        if (world.m_8055_(pos).m_60713_((Block)BYGBlocks.CARVED_BARREL_CACTUS.get())) {
            Predicate<BlockState> predicate = block -> block.m_60734_() instanceof CarvedBarrelCactusBlock && ((CarvedBarrelCactusBlock)block.m_60734_()).canReceiveStalactiteDrip(fluid);
            BiPredicate<BlockPos, BlockState> posState = (blockPos, state) -> MixinPointedDripstoneBlock.m_202017_((BlockGetter)world, blockPos, state);
            cir.setReturnValue((Object)MixinPointedDripstoneBlock.m_202006_((LevelAccessor)world, pos, Direction.DOWN.m_122421_(), posState, predicate, 11).orElse(null));
        }
    }

    @Shadow
    private static Optional<BlockPos> m_202006_(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BiPredicate<BlockPos, BlockState> posState, Predicate<BlockState> state, int j) {
        throw new UnsupportedOperationException("Mixin did not apply");
    }
}

