/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CollectionCodec;
import corgitaco.corgilib.serialization.codec.CommentedCodec;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.util.ModPlatform;

public record SettingsConfig(boolean appendBiomePlacedFeatures, boolean appendLootTables, boolean customVillagers, boolean customStructures, boolean useBYGWorldGen, LoggerSettings loggerSettings) {
    public static final Supplier<Path> CONFIG_PATH = () -> ModPlatform.INSTANCE.configPath().resolve("settings.json5");
    private static SettingsConfig INSTANCE = null;
    private static final SettingsConfig DEFAULT = new SettingsConfig(true, true, true, true, true, new LoggerSettings(false, true, false, Set.of()));
    public static final Codec<SettingsConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommentedCodec.of((Codec)Codec.BOOL, (String)"add_global_biome_placed_features", (String)"\nAdd global BYG features to non BYG biomes?\n\nBy disabling this, you remove BYG placed features not designated to specific BYG biomes.\n\nSuch features include but are not limited to:\n-Ores\n-Stones\n-Palm Trees\n\nTo configure the features that spawn using this, use the \"/corgilib worldRegistryExport\" command and edit the files found at:\n\n\"byg/worldgen/placed_feature/global/<decoration_stage>\"\n\"byg/worldgen/placed_feature/global/placed_feature/<feature>\"\n\"byg/worldgen/configured_feature/global/<decoration_stage>\"\n\nin the output folder.\n").orElse((Object)true).forGetter(config -> config.appendBiomePlacedFeatures), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"add_loot_tables", (String)"\nAdd BYG items automatically to applicable loot tables?\n\nFor example BYG may add:\n-Piglin trades to the piglin trade loot table.\n-Loot to vanilla structures such as Abandoned Mineshafts or Jungle temples.\n\nTo configure these loot tables or add your own, create a datapack with loot tables matching the following path:\n\"data/modid/append_loot_tables/file_path_to_loot_table_you_want_to_append\"\n\nExamples:\nBYG's added Piglin trades: \"data/byg/append_loot_tables/minecraft/gameplay/piglin_bartering.json\",\nBYG's added loot to abandoned mineshafts: \"data/byg/append_loot_tables/minecraft/chests/abandoned_mineshaft.json\"\nBYG's added loot to Repurposed Structure's Jungle Village Jungle House: \"data/byg/append_loot_tables/repurposed_structures/chests/villages/jungle_house.json\"\n\n").orElse((Object)true).forGetter(config -> config.appendLootTables), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"add_custom_villagers", (String)"Add custom BYG Villagers & Structures to villages?").orElse((Object)true).forGetter(config -> config.customVillagers), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"add_custom_structures", (String)"Add custom BYG Structures?").orElse((Object)true).forGetter(config -> config.customStructures), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"world_generation", (String)"Use BYG world generation?").orElse((Object)true).forGetter(config -> config.useBYGWorldGen), (App)CommentedCodec.of(LoggerSettings.CODEC, (String)"logger_settings", (String)"Logger settings.").orElse((Object)new LoggerSettings(false, false, false, Set.of())).forGetter(config -> config.loggerSettings)).apply((Applicative)builder, SettingsConfig::new));

    public static SettingsConfig getConfig() {
        return SettingsConfig.getConfig(false, false);
    }

    public static SettingsConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = SettingsConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    public static void setConfigInstance(SettingsConfig config) {
        INSTANCE = config;
    }

    private static SettingsConfig readConfig(boolean recreate) {
        Path path = CONFIG_PATH.get();
        if (!path.toFile().exists() || recreate) {
            SettingsConfig.createConfig(path);
        }
        try {
            return (SettingsConfig)JanksonUtil.readConfig((Path)path, CODEC, (DynamicOps)JanksonJsonOps.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            BYGConfigHandler.CONFIG_EXCEPTIONS.add(e);
            return DEFAULT;
        }
    }

    private static void createConfig(Path path) {
        JanksonUtil.createConfig((Path)path, CODEC, (String)"/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", Map.of(), (DynamicOps)JanksonJsonOps.INSTANCE, (Object)DEFAULT);
    }

    public record LoggerSettings(boolean logInfo, boolean logWarnings, boolean logDebug, Set<String> exclude) {
        public static final Codec<Set<String>> HASH_SET_CODEC = new CollectionCodec((Codec)Codec.STRING, HashSet::new);
        public static final Codec<LoggerSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("log_info").orElse((Object)false).forGetter(config -> config.logInfo), (App)Codec.BOOL.fieldOf("log_warnings").orElse((Object)false).forGetter(config -> config.logWarnings), (App)Codec.BOOL.fieldOf("log_debug").orElse((Object)false).forGetter(config -> config.logDebug), (App)CommentedCodec.of(HASH_SET_CODEC, (String)"exclude", (String)"Exclude BYG loggers that may contain any of the words or phrases in this list.\nExample:\n\"exclude\": [\n           \"event\",\n           \"load event\",\n           \"loaded\"\n           ]\n").orElse(Set.of()).forGetter(config -> config.exclude)).apply((Applicative)builder, LoggerSettings::new));
    }
}

