/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import potionstudios.byg.common.world.feature.config.RadiusMatcher;

public record NoisySphereConfig(BlockStateProvider blockProvider, BlockStateProvider topBlockProvider, IntProvider stackHeight, RadiusSettings radiusSettings, double radiusDivisorPerStack, float noiseFrequency, int fluidStartY, FluidState fluidState, double noise2DChance, RadiusMatcher radiusMatcher, boolean checkSquareDistance, boolean useScaledNoiseHeight, boolean pointed, boolean verfiesHeight, IntProvider belowSurfaceDepth, HolderSet<PlacedFeature> spawningFeatures) implements FeatureConfiguration
{
    public static final Codec<NoisySphereConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)BlockStateProvider.f_68747_.fieldOf("top_block_provider").forGetter(config -> config.topBlockProvider), (App)IntProvider.f_146531_.fieldOf("stackHeight").forGetter(config -> config.stackHeight), (App)RadiusSettings.CODEC.fieldOf("radius_settings").forGetter(config -> config.radiusSettings), (App)Codec.DOUBLE.fieldOf("radius_divisor_per_stack").orElse((Object)1.0).forGetter(config -> config.radiusDivisorPerStack), (App)Codec.FLOAT.fieldOf("noise_frequency").orElse((Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.noiseFrequency)), (App)Codec.INT.fieldOf("fluid_start_y").orElse((Object)12).forGetter(config -> config.fluidStartY), (App)FluidState.f_76146_.fieldOf("fluidState").orElse((Object)Fluids.f_76191_.m_76145_()).forGetter(config -> config.fluidState), (App)Codec.DOUBLE.fieldOf("2d_noise_chance").orElse((Object)0.25).forGetter(config -> config.noise2DChance), (App)RadiusMatcher.CODEC.fieldOf("radius_matcher").orElse((Object)RadiusMatcher.NONE).forGetter(config -> config.radiusMatcher), (App)Codec.BOOL.fieldOf("squared_distance_check").orElse((Object)true).forGetter(config -> config.checkSquareDistance), (App)Codec.BOOL.fieldOf("use_scaled_noise_height").orElse((Object)false).forGetter(config -> config.useScaledNoiseHeight), (App)Codec.BOOL.fieldOf("verifies_height").orElse((Object)true).forGetter(config -> config.verfiesHeight), (App)Codec.BOOL.fieldOf("pointed").orElse((Object)false).forGetter(config -> config.pointed), (App)IntProvider.f_146531_.fieldOf("belowSurfaceDepth").forGetter(config -> config.belowSurfaceDepth), (App)PlacedFeature.f_191774_.fieldOf("edge_features").forGetter(noisySphereConfig -> noisySphereConfig.spawningFeatures)).apply((Applicative)codecRecorder, NoisySphereConfig::new));

    public record RadiusSettings(IntProvider xRadius, IntProvider yRadius, int upperHalfAdditional, IntProvider zRadius) {
        public static Codec<RadiusSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntProvider.f_146531_.fieldOf("x_radius").forGetter(config -> config.xRadius), (App)IntProvider.f_146531_.fieldOf("y_radius").forGetter(config -> config.yRadius), (App)Codec.INT.fieldOf("upper_half_additional").orElse((Object)0).forGetter(config -> config.upperHalfAdditional), (App)IntProvider.f_146531_.fieldOf("z_radius").forGetter(config -> config.zRadius)).apply((Applicative)builder, RadiusSettings::new));
    }

    public static final class Builder {
        public static final BlockStateProvider DEFAULT = SimpleStateProvider.m_191382_((Block)Blocks.f_50069_);
        private BlockStateProvider blockProvider = DEFAULT;
        private BlockStateProvider topBlockProvider = DEFAULT;
        private IntProvider stackHeight = ConstantInt.m_146483_((int)1);
        private RadiusSettings radiusSettings = new RadiusSettings((IntProvider)UniformInt.m_146622_((int)1, (int)3), (IntProvider)UniformInt.m_146622_((int)1, (int)3), 0, (IntProvider)UniformInt.m_146622_((int)1, (int)3));
        private double radiusDivisorPerStack = 1.0;
        private float noiseFrequency = 0.04f;
        private int fluidStartY = Integer.MIN_VALUE;
        private FluidState fluidState = Fluids.f_76191_.m_76145_();
        private double noise2DChance = 0.25;
        private RadiusMatcher radiusMatcher = RadiusMatcher.NONE;
        private boolean checkSquareDistance = true;
        private boolean useScaledNoiseHeight = true;
        private boolean pointed = false;
        private boolean verifiesHeight = false;
        private IntProvider belowSurfaceDepth = ConstantInt.m_146483_((int)Integer.MAX_VALUE);
        private List<Holder<PlacedFeature>> spawningFeatures = new ArrayList<Holder<PlacedFeature>>();

        public Builder withBlockProvider(BlockStateProvider blockProvider) {
            this.blockProvider = blockProvider;
            return this;
        }

        public Builder withTopBlockProvider(BlockStateProvider topBlockProvider) {
            this.topBlockProvider = topBlockProvider;
            return this;
        }

        public Builder withStackHeight(IntProvider stackHeight) {
            this.stackHeight = stackHeight;
            return this;
        }

        public Builder withRadiusSettings(RadiusSettings radiusSettings) {
            this.radiusSettings = radiusSettings;
            return this;
        }

        public Builder withRadiusDivisorPerStack(double radiusDivisorPerStack) {
            this.radiusDivisorPerStack = radiusDivisorPerStack;
            return this;
        }

        public Builder withNoiseFrequency(float noiseFrequency) {
            this.noiseFrequency = noiseFrequency;
            return this;
        }

        public Builder withFluidStartY(int fluidStartY) {
            this.fluidStartY = fluidStartY;
            return this;
        }

        public Builder withFluidState(FluidState fluidState) {
            this.fluidState = fluidState;
            return this;
        }

        public Builder withNoise2DChance(double noise2DChance) {
            this.noise2DChance = noise2DChance;
            return this;
        }

        public Builder withRadiusMatcher(RadiusMatcher radiusMatcher) {
            this.radiusMatcher = radiusMatcher;
            return this;
        }

        public Builder withCheckSquareDistance(boolean checkSquareDistance) {
            this.checkSquareDistance = checkSquareDistance;
            return this;
        }

        public Builder withScaledHeight(boolean useScaledNoiseHeight) {
            this.useScaledNoiseHeight = useScaledNoiseHeight;
            return this;
        }

        public Builder withPointed(boolean pointed) {
            this.pointed = pointed;
            return this;
        }

        public Builder withVerifiesHeight(boolean verifiesHeight) {
            this.verifiesHeight = verifiesHeight;
            return this;
        }

        public Builder withBelowSurfaceDepth(IntProvider belowSurfaceDepth) {
            this.belowSurfaceDepth = belowSurfaceDepth;
            return this;
        }

        public Builder withSpawningFeatures(List<Holder<PlacedFeature>> spawningFeatures) {
            this.spawningFeatures = spawningFeatures;
            return this;
        }

        public Builder copy(Supplier<? extends NoisySphereConfig> copy) {
            return this.copy(copy.get());
        }

        public Builder copy(NoisySphereConfig copy) {
            this.blockProvider = copy.blockProvider;
            this.topBlockProvider = copy.topBlockProvider;
            this.stackHeight = copy.stackHeight;
            this.radiusSettings = copy.radiusSettings;
            this.radiusDivisorPerStack = copy.radiusDivisorPerStack;
            this.noiseFrequency = copy.noiseFrequency;
            this.fluidStartY = copy.fluidStartY;
            this.fluidState = copy.fluidState;
            this.noise2DChance = copy.noise2DChance;
            this.radiusMatcher = copy.radiusMatcher;
            this.checkSquareDistance = copy.checkSquareDistance;
            this.useScaledNoiseHeight = copy.useScaledNoiseHeight;
            this.belowSurfaceDepth = copy.belowSurfaceDepth;
            this.pointed = copy.pointed;
            this.verifiesHeight = copy.verfiesHeight;
            this.spawningFeatures = copy.spawningFeatures.m_203614_().toList();
            return this;
        }

        public NoisySphereConfig build() {
            return new NoisySphereConfig(this.blockProvider, this.topBlockProvider, this.stackHeight, this.radiusSettings, this.radiusDivisorPerStack, this.noiseFrequency, this.fluidStartY, this.fluidState, this.noise2DChance, this.radiusMatcher, this.checkSquareDistance, this.useScaledNoiseHeight, this.pointed, this.verifiesHeight, this.belowSurfaceDepth, (HolderSet<PlacedFeature>)HolderSet.m_205800_(this.spawningFeatures));
        }
    }
}

