/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.content.distant_signals.SignalDisplaySource;
import com.railwayteam.railways.mixin.AccessorBlockEntityType;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CRExtraRegistration {
    public static boolean registeredSignalSource = false;
    public static boolean registeredVentAsCopycat = false;

    public static void register() {
        BlockEntityType maybeRegisteredCopycat;
        Block maybeRegistered;
        try {
            maybeRegistered = (Block)AllBlocks.TRACK_SIGNAL.get();
        }
        catch (NullPointerException ignored) {
            maybeRegistered = null;
        }
        try {
            maybeRegisteredCopycat = (BlockEntityType)AllBlockEntityTypes.COPYCAT.get();
        }
        catch (NullPointerException ignored) {
            maybeRegisteredCopycat = null;
        }
        Create.REGISTRATE.addRegisterCallback("track_signal", Registry.f_122901_, CRExtraRegistration::addSignalSource);
        Create.REGISTRATE.addRegisterCallback("copycat", Registry.f_122907_, CRExtraRegistration::addVentAsCopycat);
        if (maybeRegistered != null) {
            CRExtraRegistration.addSignalSource(maybeRegistered);
        }
        if (maybeRegisteredCopycat != null) {
            CRExtraRegistration.addVentAsCopycat(maybeRegisteredCopycat);
        }
    }

    private static void addVentAsCopycat(BlockEntityType<?> object) {
        Block ventBlock;
        if (registeredVentAsCopycat) {
            return;
        }
        try {
            ventBlock = (Block)CRBlocks.CONDUCTOR_VENT.get();
        }
        catch (NullPointerException ignored) {
            return;
        }
        ImmutableSet validBlocks = ((AccessorBlockEntityType)object).getValidBlocks();
        validBlocks = new ImmutableSet.Builder().add((Object[])((Block[])validBlocks.toArray(Block[]::new))).add((Object)ventBlock).build();
        ((AccessorBlockEntityType)object).setValidBlocks((Set<Block>)validBlocks);
        registeredVentAsCopycat = true;
    }

    public static void addSignalSource(Block block) {
        if (registeredSignalSource) {
            return;
        }
        AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SignalDisplaySource(), (String[])new String[0]).accept((Object)block);
        registeredSignalSource = true;
    }
}

