/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.mixin.AccessorNavigation;
import com.railwayteam.railways.mixin_interfaces.IIndexedSchedule;
import com.railwayteam.railways.mixin_interfaces.IOccupiedCouplers;
import com.railwayteam.railways.mixin_interfaces.IWaypointableNavigation;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Train.class}, remap=false)
public abstract class MixinTrain
implements IOccupiedCouplers,
IIndexedSchedule {
    @Shadow
    public TrackGraph graph;
    @Shadow
    public Navigation navigation;
    @Shadow
    public double speed;
    @Shadow
    public ScheduleRuntime runtime;
    @Shadow
    public List<Carriage> carriages;
    @Shadow
    public boolean invalid;
    public Set<UUID> occupiedCouplers;
    protected int index = 0;

    @Shadow
    public abstract void arriveAt(GlobalStation var1);

    @Shadow
    public abstract void leaveStation();

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Set<UUID> getOccupiedCouplers() {
        return this.occupiedCouplers;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initCouplers(UUID id, UUID owner, TrackGraph graph, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded, CallbackInfo ci) {
        this.occupiedCouplers = new HashSet<UUID>();
    }

    @Inject(method={"earlyTick"}, at={@At(value="HEAD")})
    private void killEmptyTrains(Level level, CallbackInfo ci) {
        if (this.carriages.size() == 0) {
            this.invalid = true;
        }
    }

    @Inject(method={"earlyTick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;addToSignalGroups(Ljava/util/Collection;)V", ordinal=2)})
    private void tickOccupiedCouplers(Level level, CallbackInfo ci) {
        for (UUID uuid : this.occupiedCouplers) {
            TrackCoupler coupler = (TrackCoupler)this.graph.getPoint(CREdgePointTypes.COUPLER, uuid);
            if (coupler == null) continue;
            coupler.keepAlive((Train)this);
        }
    }

    @Inject(method={"frontSignalListener"}, at={@At(value="RETURN")}, cancellable=true)
    private void frontCouplerListener(CallbackInfoReturnable<TravellingPoint.IEdgePointListener> cir) {
        TravellingPoint.IEdgePointListener originalListener = (TravellingPoint.IEdgePointListener)cir.getReturnValue();
        cir.setReturnValue((distance, couple) -> {
            Object patt4209$temp;
            Object patt3972$temp = couple.getFirst();
            if (patt3972$temp instanceof TrackCoupler) {
                TrackCoupler trackCoupler = (TrackCoupler)((Object)((Object)patt3972$temp));
                this.occupiedCouplers.add(trackCoupler.getId());
                return false;
            }
            if (((IWaypointableNavigation)this.navigation).isWaypointMode() && (patt4209$temp = couple.getFirst()) instanceof GlobalStation) {
                GlobalStation station = (GlobalStation)patt4209$temp;
                if (!station.canApproachFrom((TrackNode)((Couple)couple.getSecond()).getSecond()) || this.navigation.destination != station) {
                    return false;
                }
                this.navigation.distanceToDestination = 0.0;
                ((AccessorNavigation)this.navigation).getCurrentPath().clear();
                this.arriveAt(this.navigation.destination);
                this.navigation.destination = null;
                return true;
            }
            return originalListener.test(distance, couple);
        });
    }

    @Inject(method={"lambda$backSignalListener$12", "lambda$backSignalListener$10"}, at={@At(value="HEAD")}, cancellable=true)
    private void backCouplerListener(Double distance, Pair<TrackEdgePoint, Couple<TrackNode>> couple, CallbackInfoReturnable<Boolean> cir) {
        Object object = couple.getFirst();
        if (object instanceof TrackCoupler) {
            TrackCoupler coupler = (TrackCoupler)((Object)object);
            this.occupiedCouplers.remove(coupler.getId());
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"collectInitiallyOccupiedSignalBlocks"}, at={@At(value="INVOKE", target="Ljava/util/Set;clear()V", ordinal=0)})
    private void clearOccupiedCouplers(CallbackInfo ci) {
        this.occupiedCouplers.clear();
    }

    @Inject(method={"lambda$collectInitiallyOccupiedSignalBlocks$20", "lambda$collectInitiallyOccupiedSignalBlocks$18"}, at={@At(value="HEAD")}, cancellable=true)
    private void reAddOccupiedCouplers(MutableObject<UUID> prevGroup, Double distance, Pair<TrackEdgePoint, Couple<TrackNode>> couple, CallbackInfoReturnable<Boolean> cir) {
        Object object = couple.getFirst();
        if (object instanceof TrackCoupler) {
            TrackCoupler coupler = (TrackCoupler)((Object)object);
            this.occupiedCouplers.add(coupler.getId());
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeOccupiedCouplers(DimensionPalette dimensions, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        tag.m_128365_("OccupiedCouplers", (Tag)NBTHelper.writeCompoundList(this.occupiedCouplers, uid -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("Id", uid);
            return compoundTag;
        }));
        tag.m_128405_("ScheduleHolderIndex", this.index);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void readOccupiedCouplers(CompoundTag tag, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions, CallbackInfoReturnable<Train> cir, UUID id, UUID owner, UUID graphId, TrackGraph graph, List<Carriage> carriages, List<Double> carriageSpacing, boolean doubleEnded, Train train) {
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("OccupiedCouplers", 10), c -> ((IOccupiedCouplers)train).getOccupiedCouplers().add(c.m_128342_("Id")));
        ((IIndexedSchedule)train).setIndex(tag.m_128451_("ScheduleHolderIndex"));
    }

    @Inject(method={"collideWithOtherTrains"}, at={@At(value="HEAD")}, cancellable=true)
    private void maybeNoCollision(Level level, Carriage carriage, CallbackInfo ci) {
        if (((Boolean)CRConfigs.server().optimization.disableTrainCollision.get()).booleanValue()) {
            ci.cancel();
        }
    }
}

