/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    @Nullable
    public static INetworkNode getNodeFromBlockEntity(@Nullable BlockEntity blockEntity) {
        INetworkNodeProxy proxy;
        if (blockEntity != null && (proxy = (INetworkNodeProxy)blockEntity.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY).orElse(null)) != null) {
            return proxy.getNode();
        }
        return null;
    }

    @Nullable
    public static INetwork getNetworkFromNode(@Nullable INetworkNode node) {
        if (node != null) {
            return node.getNetwork();
        }
        return null;
    }

    public static InteractionResult attemptModify(Level level, BlockPos pos, Player player, Runnable action) {
        return NetworkUtils.attempt(level, pos, player, action, Permission.MODIFY);
    }

    public static InteractionResult attempt(Level level, BlockPos pos, Player player, Runnable action, Permission ... permissionsRequired) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromBlockEntity(level.m_7702_(pos)));
        if (network != null) {
            for (Permission permission : permissionsRequired) {
                if (network.getSecurityManager().hasPermission(permission, player)) continue;
                LevelUtils.sendNoPermissionMessage(player);
                return InteractionResult.SUCCESS;
            }
        }
        action.run();
        return InteractionResult.SUCCESS;
    }

    public static void extractBucketFromPlayerInventoryOrNetwork(Player player, INetwork network, Consumer<ItemStack> onBucketFound) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slot = player.m_150109_().m_8020_(i);
            if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
            player.m_150109_().m_7407_(i, 1);
            onBucketFound.accept(StackUtils.EMPTY_BUCKET.m_41777_());
            return;
        }
        ItemStack fromNetwork = network.extractItem(StackUtils.EMPTY_BUCKET, 1, Action.PERFORM);
        if (!fromNetwork.m_41619_()) {
            onBucketFound.accept(fromNetwork);
        }
    }
}

