/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.apiimpl.network.item.WirelessCraftingMonitorNetworkItem;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.NetworkItem;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WirelessCraftingMonitorItem
extends NetworkItem {
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";
    private final Type type;

    public WirelessCraftingMonitorItem(Type type) {
        super(new Item.Properties().m_41491_(RS.CREATIVE_MODE_TAB).m_41487_(1), type == Type.CREATIVE, () -> RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCapacity());
        this.type = type;
    }

    public static Optional<UUID> getTabSelected(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128403_(NBT_TAB_SELECTED)) {
            return Optional.of(stack.m_41783_().m_128342_(NBT_TAB_SELECTED));
        }
        return Optional.empty();
    }

    public static void setTabSelected(ItemStack stack, Optional<UUID> tabSelected) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (tabSelected.isPresent()) {
            stack.m_41783_().m_128362_(NBT_TAB_SELECTED, tabSelected.get());
        } else {
            stack.m_41783_().m_128473_("TabSelectedLeast");
            stack.m_41783_().m_128473_("TabSelectedMost");
        }
    }

    public static int getTabPage(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_TAB_PAGE)) {
            return stack.m_41783_().m_128451_(NBT_TAB_PAGE);
        }
        return 0;
    }

    public static void setTabPage(ItemStack stack, int tabPage) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128405_(NBT_TAB_PAGE, tabPage);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public INetworkItem provide(INetworkItemManager handler, Player player, ItemStack stack, PlayerSlot slot) {
        return new WirelessCraftingMonitorNetworkItem(handler, player, stack, slot);
    }

    public static enum Type {
        NORMAL,
        CREATIVE;

    }
}

