/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.datageneration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.loottable.ControllerLootFunction;
import com.refinedmods.refinedstorage.loottable.CrafterLootFunction;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(RSBlockLootTables::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    public String m_6055_() {
        return "Refined Storage Loot Tables";
    }

    private static class RSBlockLootTables
    extends BlockLoot {
        private RSBlockLootTables() {
        }

        protected void addTables() {
            RSBlocks.CONTROLLER.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), (LootItemFunction.Builder)ControllerLootFunction.builder()));
            RSBlocks.CREATIVE_CONTROLLER.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.CRAFTER.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), (LootItemFunction.Builder)CrafterLootFunction.builder()));
            RSBlocks.GRID.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.CRAFTING_GRID.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.FLUID_GRID.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.PATTERN_GRID.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.SECURITY_MANAGER.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.WIRELESS_TRANSMITTER.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.RELAY.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.NETWORK_TRANSMITTER.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.NETWORK_RECEIVER.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.DISK_MANIPULATOR.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.CRAFTING_MONITOR.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.CRAFTER_MANAGER.values().forEach(block -> this.m_124288_((Block)block.get()));
            RSBlocks.DETECTOR.values().forEach(block -> this.m_124288_((Block)block.get()));
        }

        protected Iterable<Block> getKnownBlocks() {
            return RSBlocks.COLORED_BLOCKS.stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        private void genBlockItemLootTableWithFunction(Block block, LootItemFunction.Builder builder) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_(builder)).m_79080_(ExplosionCondition.m_81661_())));
        }
    }
}

