/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.GridFactoryType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.IGridFactory;
import com.refinedmods.refinedstorage.api.network.grid.IGridManager;
import com.refinedmods.refinedstorage.container.factory.GridMenuProvider;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class GridManager
implements IGridManager {
    private final Map<ResourceLocation, IGridFactory> factories = new HashMap<ResourceLocation, IGridFactory>();

    @Override
    public void add(ResourceLocation id, IGridFactory factory) {
        this.factories.put(id, factory);
    }

    @Override
    public void openGrid(ResourceLocation id, ServerPlayer player, BlockPos pos) {
        this.openGrid(id, player, null, pos, new PlayerSlot(-1));
    }

    @Override
    public void openGrid(ResourceLocation id, ServerPlayer player, ItemStack stack, PlayerSlot slot) {
        this.openGrid(id, player, stack, null, slot);
    }

    private void openGrid(ResourceLocation id, ServerPlayer player, @Nullable ItemStack stack, @Nullable BlockPos pos, PlayerSlot slot) {
        Pair<IGrid, BlockEntity> grid = this.createGrid(id, (Player)player, stack, pos, slot);
        if (grid == null) {
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new GridMenuProvider((IGrid)grid.getLeft(), (BlockEntity)grid.getRight()), buf -> {
            buf.m_130085_(id);
            buf.writeBoolean(pos != null);
            if (pos != null) {
                buf.m_130064_(pos);
            }
            buf.writeBoolean(stack != null);
            if (stack != null) {
                buf.m_130055_(stack);
            }
            slot.writePlayerSlot((FriendlyByteBuf)buf);
        });
    }

    @Override
    @Nullable
    public Pair<IGrid, BlockEntity> createGrid(ResourceLocation id, Player player, @Nullable ItemStack stack, @Nullable BlockPos pos, PlayerSlot slot) {
        IGridFactory factory = this.factories.get(id);
        if (factory == null) {
            return null;
        }
        IGrid grid = null;
        BlockEntity blockEntity = factory.getRelevantBlockEntity(player.f_19853_, pos);
        if (factory.getType() == GridFactoryType.STACK) {
            grid = factory.createFromStack(player, stack, slot);
        } else if (factory.getType() == GridFactoryType.BLOCK) {
            grid = factory.createFromBlock(player, pos);
        }
        if (grid == null) {
            return null;
        }
        return Pair.of((Object)grid, (Object)blockEntity);
    }
}

