/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import shadows.placebo.json.ItemAdapter;

public class StackLootEntry
extends LootPoolSingletonContainer {
    public static final Serializer SERIALIZER = new Serializer();
    public static final LootPoolEntryType STACKLOOTENTRYTYPE = (LootPoolEntryType)Registry.m_122965_((Registry)Registry.f_122875_, (ResourceLocation)new ResourceLocation("placebo", "stack_entry"), (Object)new LootPoolEntryType((net.minecraft.world.level.storage.loot.Serializer)SERIALIZER));
    private final ItemStack stack;
    private final int min;
    private final int max;

    public StackLootEntry(ItemStack stack, int min, int max, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.stack = stack;
        this.min = min;
        this.max = max;
    }

    public StackLootEntry(ItemStack stack, int min, int max, int weight, int quality) {
        this(stack, min, max, weight, quality, new LootItemCondition[0], new LootItemFunction[0]);
    }

    public StackLootEntry(ItemLike item, int min, int max, int weight, int quality) {
        this(new ItemStack(item), min, max, weight, quality);
    }

    public StackLootEntry(ItemStack stack) {
        this(stack, 1, 1, 1, 0);
    }

    protected void m_6948_(Consumer<ItemStack> list, LootContext ctx) {
        ItemStack s = this.stack.m_41777_();
        s.m_41764_(Mth.m_216271_((RandomSource)ctx.m_230907_(), (int)this.min, (int)this.max));
        list.accept(s);
    }

    public LootPoolEntryType m_6751_() {
        return STACKLOOTENTRYTYPE;
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<StackLootEntry> {
        protected StackLootEntry deserialize(JsonObject jsonObject, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] lootConditions, LootItemFunction[] lootFunctions) {
            int min = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"min", (int)1);
            int max = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"max", (int)1);
            ItemStack stack = (ItemStack)ItemAdapter.ITEM_READER.fromJson(jsonObject.get("stack"), ItemStack.class);
            return new StackLootEntry(stack, min, max, weight, quality, lootConditions, lootFunctions);
        }

        public void serializeCustom(JsonObject object, StackLootEntry e, JsonSerializationContext conditions) {
            super.m_7219_(object, (LootPoolSingletonContainer)e, conditions);
            object.addProperty("min", (Number)e.min);
            object.addProperty("max", (Number)e.max);
            object.add("stack", ItemAdapter.ITEM_READER.toJsonTree((Object)e.stack));
        }
    }
}

