/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PipeBlockEntity
extends BlockEntity
implements MenuProvider,
IPipeConnectable {
    public final ItemStackHandler modules = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            Item item = stack.m_41720_();
            if (!(item instanceof IModule)) {
                return false;
            }
            IModule module = (IModule)item;
            return PipeBlockEntity.this.streamModules().allMatch(m -> module.isCompatible(stack, PipeBlockEntity.this, (IModule)m.getRight()) && ((IModule)m.getRight()).isCompatible((ItemStack)m.getLeft(), PipeBlockEntity.this, module));
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            PipeBlockEntity.this.m_6596_();
        }
    };
    public final Queue<NetworkLock> craftIngredientRequests = new LinkedList<NetworkLock>();
    public final List<Pair<BlockPos, ItemStack>> craftResultRequests = new ArrayList<Pair<BlockPos, ItemStack>>();
    public PressurizerBlockEntity pressurizer;
    public BlockState cover;
    public int moduleDropCheck;
    protected List<IPipeItem> items;
    private int lastItemAmount;
    private int priority;
    private final LazyOptional<PipeBlockEntity> lazyThis = LazyOptional.of(() -> this);
    private final Lazy<Integer> workRandomizer = Lazy.of(() -> this.f_58857_.f_46441_.m_188503_(200));

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.pipeBlockEntity, pos, state);
    }

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onChunkUnloaded() {
        PipeNetwork.get(this.f_58857_).uncachePipe(this.f_58858_);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("modules", (Tag)this.modules.serializeNBT());
        compound.m_128405_("module_drop_check", this.moduleDropCheck);
        compound.m_128365_("requests", (Tag)Utility.serializeAll(this.craftIngredientRequests));
        if (this.cover != null) {
            compound.m_128365_("cover", (Tag)NbtUtils.m_129202_((BlockState)this.cover));
        }
        ListTag results = new ListTag();
        for (Pair<BlockPos, ItemStack> triple : this.craftResultRequests) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("dest_pipe", ((BlockPos)triple.getLeft()).m_121878_());
            nbt.m_128365_("item", (Tag)((ItemStack)triple.getRight()).serializeNBT());
            results.add((Object)nbt);
        }
        compound.m_128365_("craft_results", (Tag)results);
    }

    public void m_142466_(CompoundTag compound) {
        this.modules.deserializeNBT(compound.m_128469_("modules"));
        this.moduleDropCheck = compound.m_128451_("module_drop_check");
        this.cover = compound.m_128441_("cover") ? NbtUtils.m_129241_((CompoundTag)compound.m_128469_("cover")) : null;
        this.craftIngredientRequests.clear();
        this.craftIngredientRequests.addAll(Utility.deserializeAll(compound.m_128437_("requests", 10), NetworkLock::new));
        this.craftResultRequests.clear();
        ListTag results = compound.m_128437_("craft_results", 10);
        for (int i = 0; i < results.size(); ++i) {
            CompoundTag nbt = results.m_128728_(i);
            this.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)BlockPos.m_122022_((long)nbt.m_128454_("dest_pipe")), (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"))));
        }
        super.m_142466_(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = this.m_187482_();
        nbt.m_128365_("items", (Tag)Utility.serializeAll(this.getItems()));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
        List<IPipeItem> items = this.getItems();
        items.clear();
        items.addAll(Utility.deserializeAll(nbt.m_128437_("items", 10), IPipeItem::load));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public List<IPipeItem> getItems() {
        if (this.items == null) {
            this.items = PipeNetwork.get(this.f_58857_).getItemsInPipe(this.f_58858_);
        }
        return this.items;
    }

    public void addNewItem(IPipeItem item) {
        if (!this.getItems().contains(item)) {
            this.getItems().add(item);
        }
        if (this.pressurizer != null) {
            this.pressurizer.pressurizeItem(item.getContent(), false);
        }
    }

    public boolean isConnected(Direction dir) {
        return ((ConnectionType)((Object)this.m_58900_().m_61143_((Property)PipeBlock.DIRECTIONS.get(dir)))).isConnected();
    }

    public Pair<BlockPos, ItemStack> getAvailableDestinationOrConnectable(ItemStack stack, boolean force, boolean preventOversending) {
        Pair<BlockPos, ItemStack> dest = this.getAvailableDestination(Direction.values(), stack, force, preventOversending);
        if (dest != null) {
            return dest;
        }
        for (Direction dir : Direction.values()) {
            ItemStack connectableRemain;
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || (connectableRemain = connectable.insertItem(this.f_58858_, dir, stack, true)).m_41613_() == stack.m_41613_()) continue;
            ItemStack inserted = stack.m_41777_();
            inserted.m_41774_(connectableRemain.m_41613_());
            return Pair.of((Object)this.f_58858_.m_121945_(dir), (Object)inserted);
        }
        return null;
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(Direction[] directions, ItemStack stack, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        for (Direction dir : directions) {
            PipeNetwork network;
            int onTheWay;
            IItemHandler handler = this.getItemHandler(dir);
            if (handler == null || !force && this.streamModules().anyMatch(m -> !((IModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), this, stack, dir, handler))) continue;
            int startSlot = 0;
            int slotAmount = handler.getSlots();
            if (handler.getClass().getName().equals("com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler")) {
                slotAmount = 1;
            }
            ItemStack remain = stack;
            for (int i = startSlot; i < slotAmount && !(remain = handler.insertItem(i, remain, true)).m_41619_(); ++i) {
            }
            if (remain.m_41613_() == stack.m_41613_()) continue;
            ItemStack toInsert = stack.m_41777_();
            toInsert.m_41774_(remain.m_41613_());
            int maxAmount = this.streamModules().mapToInt(m -> ((IModule)m.getRight()).getMaxInsertionAmount((ItemStack)m.getLeft(), this, stack, handler)).min().orElse(Integer.MAX_VALUE);
            if (maxAmount < toInsert.m_41613_()) {
                toInsert.m_41764_(maxAmount);
            }
            BlockPos offset = this.f_58858_.m_121945_(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get(this.f_58857_)).getItemsOnTheWay(offset, null, new ItemEquality[0])) > 0) {
                if (maxAmount < Integer.MAX_VALUE) {
                    int onTheWaySame = network.getItemsOnTheWay(offset, stack, new ItemEquality[0]);
                    if (toInsert.m_41613_() + onTheWaySame > maxAmount) {
                        toInsert.m_41764_(maxAmount - onTheWaySame);
                    }
                }
                int totalSpace = 0;
                ItemStack copy = stack.m_41777_();
                for (int i = startSlot; i < slotAmount; ++i) {
                    int maxStackSize = copy.m_41741_();
                    int limit = handler.getSlotLimit(i);
                    if (limit > 64) {
                        maxStackSize = limit;
                    }
                    copy.m_41764_(maxStackSize);
                    ItemStack left = handler.insertItem(i, copy, true);
                    totalSpace += maxStackSize - left.m_41613_();
                }
                if (onTheWay + toInsert.m_41613_() > totalSpace) {
                    toInsert.m_41764_(totalSpace - onTheWay);
                }
            }
            if (toInsert.m_41619_()) continue;
            return Pair.of((Object)offset, (Object)toInsert);
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getItemSpeed(ItemStack stack) {
        float moduleSpeed = (float)this.streamModules().mapToDouble(m -> ((IModule)m.getRight()).getItemSpeedIncrease((ItemStack)m.getLeft(), this)).sum();
        float pressureSpeed = this.pressurizer != null && this.pressurizer.pressurizeItem(stack, true) ? 0.45f : 0.0f;
        return 0.05f + moduleSpeed + pressureSpeed;
    }

    public boolean canWork() {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canPipeWork((ItemStack)m.getLeft(), this));
    }

    public List<ItemStack> getAllCraftables() {
        return this.streamModules().flatMap(m -> ((IModule)m.getRight()).getAllCraftables((ItemStack)m.getLeft(), this).stream()).collect(Collectors.toList());
    }

    public int getCraftableAmount(Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int total = 0;
        Iterator modules = this.streamModules().iterator();
        while (modules.hasNext()) {
            int amount;
            Pair module = (Pair)modules.next();
            if (dependencyChain.contains(module.getLeft()) || (amount = ((IModule)module.getRight()).getCraftableAmount((ItemStack)module.getLeft(), this, unavailableConsumer, stack, dependencyChain)) <= 0) continue;
            total += amount;
        }
        return total;
    }

    public ItemStack craft(BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        Pair module;
        Iterator modules = this.streamModules().iterator();
        while (modules.hasNext() && !(stack = ((IModule)(module = (Pair)modules.next()).getRight()).craft((ItemStack)module.getLeft(), this, destPipe, unavailableConsumer, stack, dependencyChain)).m_41619_()) {
        }
        return stack;
    }

    public IItemHandler getItemHandler(Direction dir) {
        IItemHandler handler = (IItemHandler)this.getNeighborCap(dir, ForgeCapabilities.ITEM_HANDLER);
        if (handler != null) {
            return handler;
        }
        return Utility.getBlockItemHandler(this.f_58857_, this.f_58858_.m_121945_(dir), dir.m_122424_());
    }

    public <T> T getNeighborCap(Direction dir, Capability<T> cap) {
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.f_58858_.m_121945_(dir);
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile != null) {
            return (T)tile.getCapability(cap, dir.m_122424_()).orElse(null);
        }
        return null;
    }

    public IPipeConnectable getPipeConnectable(Direction dir) {
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
        if (tile != null) {
            return (IPipeConnectable)tile.getCapability(Registry.pipeConnectableCapability, dir.m_122424_()).orElse(null);
        }
        return null;
    }

    public boolean canHaveModules() {
        for (Direction dir : Direction.values()) {
            if (this.getItemHandler(dir) != null) {
                return true;
            }
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || !connectable.allowsModules(this.f_58858_, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean canNetworkSee(Direction direction, IItemHandler handler) {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canNetworkSee((ItemStack)m.getLeft(), this, direction, handler));
    }

    public Stream<Pair<ItemStack, IModule>> streamModules() {
        Stream.Builder<Pair> builder = Stream.builder();
        for (int i = 0; i < this.modules.getSlots(); ++i) {
            Item item;
            ItemStack stack = this.modules.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IModule)) continue;
            IModule module = (IModule)item;
            builder.accept(Pair.of((Object)stack, (Object)module));
        }
        return builder.build();
    }

    public void removeCover(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        List drops = Block.m_49874_((BlockState)this.cover, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_, null, (Entity)player, (ItemStack)player.m_21120_(hand));
        for (ItemStack drop : drops) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)drop);
        }
        this.cover = null;
    }

    public boolean shouldWorkNow(int speed) {
        return (this.f_58857_.m_46467_() + (long)((Integer)this.workRandomizer.get()).intValue()) % (long)speed == 0L;
    }

    public int getNextNode(List<BlockPos> nodes, int index) {
        return this.streamModules().map(m -> ((IModule)m.getRight()).getCustomNextNode((ItemStack)m.getLeft(), this, nodes, index)).filter(Objects::nonNull).findFirst().orElse(index);
    }

    public List<ItemFilter> getFilters() {
        return this.streamModules().map(p -> ((IModule)p.getRight()).getItemFilter((ItemStack)p.getLeft(), this)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void m_7651_() {
        super.m_7651_();
        this.getItems().clear();
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        for (NetworkLock lock : this.craftIngredientRequests) {
            network.resolveNetworkLock(lock);
        }
        this.lazyThis.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.prettypipes.pipe");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int window, Inventory inv, Player player) {
        return new MainPipeContainer(Registry.pipeContainer, window, player, this.f_58858_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Registry.pipeConnectableCapability) {
            return this.lazyThis.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        BlockState state = this.f_58857_.m_8055_(pipePos.m_121945_(direction));
        if (state.m_61143_((Property)PipeBlock.DIRECTIONS.get(direction.m_122424_())) == ConnectionType.BLOCKED) {
            return ConnectionType.BLOCKED;
        }
        return ConnectionType.CONNECTED;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PipeBlockEntity pipe) {
        if (pipe.pressurizer != null && pipe.pressurizer.m_58901_()) {
            pipe.pressurizer = null;
        }
        if (!pipe.f_58857_.isAreaLoaded(pipe.f_58858_, 1)) {
            return;
        }
        ProfilerFiller profiler = pipe.f_58857_.m_46473_();
        if (!pipe.f_58857_.f_46443_) {
            if (pipe.moduleDropCheck > 0) {
                --pipe.moduleDropCheck;
                if (pipe.moduleDropCheck <= 0 && !pipe.canHaveModules()) {
                    Utility.dropInventory(pipe, (IItemHandler)pipe.modules);
                }
            }
            profiler.m_6180_("ticking_modules");
            int prio = 0;
            Iterator modules = pipe.streamModules().iterator();
            while (modules.hasNext()) {
                Pair module = (Pair)modules.next();
                ((IModule)module.getRight()).tick((ItemStack)module.getLeft(), pipe);
                prio += ((IModule)module.getRight()).getPriority((ItemStack)module.getLeft(), pipe);
            }
            if (prio != pipe.priority) {
                pipe.priority = prio;
                PipeNetwork.get(pipe.f_58857_).clearDestinationCache(Collections.singletonList(pipe.f_58858_));
            }
            profiler.m_7238_();
        }
        profiler.m_6180_("ticking_items");
        List<IPipeItem> items = pipe.getItems();
        for (int i = items.size() - 1; i >= 0; --i) {
            items.get(i).updateInPipe(pipe);
        }
        if (items.size() != pipe.lastItemAmount) {
            pipe.lastItemAmount = items.size();
            pipe.f_58857_.m_46717_(pipe.f_58858_, pipe.m_58900_().m_60734_());
        }
        profiler.m_7238_();
    }
}

