/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.util.TriConsumer;

public class PacketButton {
    private BlockPos pos;
    private ButtonResult result;
    private int[] data;

    public PacketButton(BlockPos pos, ButtonResult result, int ... data) {
        this.pos = pos;
        this.result = result;
        this.data = data;
    }

    private PacketButton() {
    }

    public static PacketButton fromBytes(FriendlyByteBuf buf) {
        PacketButton packet = new PacketButton();
        packet.pos = buf.m_130135_();
        packet.result = ButtonResult.values()[buf.readByte()];
        packet.data = buf.m_130100_();
        return packet;
    }

    public static void toBytes(PacketButton packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeByte(packet.result.ordinal());
        buf.m_130089_(packet.data);
    }

    public static void onMessage(final PacketButton message, final Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                message.result.action.accept((Object)message.pos, (Object)message.data, (Object)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, int ... data) {
        PacketHandler.sendToServer(new PacketButton(pos, result, data));
        result.action.accept((Object)pos, (Object)data, (Object)Minecraft.m_91087_().f_91074_);
    }

    public static enum ButtonResult {
        PIPE_TAB((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            final PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)player.f_19853_, pos);
            if (data[0] < 0) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
            } else {
                final ItemStack stack = tile.modules.getStackInSlot(data[0]);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){
                    final /* synthetic */ int[] val$data;
                    {
                        this.val$data = nArray;
                    }

                    public Component m_5446_() {
                        return stack.m_41786_();
                    }

                    @Nullable
                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return ((IModule)stack.m_41720_()).getContainer(stack, tile, windowId, inv, player, this.val$data[0]);
                    }
                }, buf -> {
                    buf.m_130064_(pos);
                    buf.writeInt(data[0]);
                });
            }
        })),
        FILTER_CHANGE((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt4144$temp = player.f_36096_;
            if (patt4144$temp instanceof ItemFilter.IFilteredContainer) {
                ItemFilter.IFilteredContainer filtered = (ItemFilter.IFilteredContainer)patt4144$temp;
                filtered.getFilter().onButtonPacket(filtered, data[0]);
            }
        })),
        STACK_SIZE_MODULE_BUTTON((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.f_36096_;
            StackSizeModuleItem.setLimitToMaxStackSize(container.moduleStack, !StackSizeModuleItem.getLimitToMaxStackSize(container.moduleStack));
        })),
        STACK_SIZE_AMOUNT((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.f_36096_;
            StackSizeModuleItem.setMaxStackSize(container.moduleStack, data[0]);
        })),
        CRAFT_TERMINAL_REQUEST((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)player.f_19853_, pos);
            tile.requestCraftingItems((Player)player, data[0], data[1] > 0);
        })),
        CANCEL_CRAFTING((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.f_19853_, pos);
            tile.cancelCrafting();
        })),
        TAG_FILTER((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            FilterModifierModuleContainer container = (FilterModifierModuleContainer)player.f_36096_;
            FilterModifierModuleItem.setFilterTag(container.moduleStack, container.getTags().get(data[0]));
        })),
        DIRECTION_SELECTOR((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt5573$temp = player.f_36096_;
            if (patt5573$temp instanceof DirectionSelector.IDirectionContainer) {
                DirectionSelector.IDirectionContainer filtered = (DirectionSelector.IDirectionContainer)patt5573$temp;
                filtered.getSelector().onButtonPacket();
            }
        }));

        public final TriConsumer<BlockPos, int[], Player> action;

        private ButtonResult(TriConsumer<BlockPos, int[], Player> action) {
            this.action = action;
        }
    }
}

