/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.items;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class WrenchItem
extends Item {
    public WrenchItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(Registry.TAB));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack offhand;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof PipeBlock)) {
            return InteractionResult.PASS;
        }
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_()) {
            if (!world.f_46443_) {
                if (tile.cover != null) {
                    tile.removeCover(player, context.m_43724_());
                    Utility.sendBlockEntityToClients(tile);
                } else {
                    PipeBlock.dropItems(world, pos, player);
                    Block.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)tile, null, (ItemStack)ItemStack.f_41583_);
                    world.m_7471_(pos, false);
                }
                world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (tile.cover == null && (offhand = player.m_21206_()).m_41720_() instanceof BlockItem) {
            if (!world.f_46443_) {
                BlockPlaceContext blockContext = new BlockPlaceContext(context);
                Block block = ((BlockItem)offhand.m_41720_()).m_40614_();
                BlockState cover = block.m_5573_(blockContext);
                if (cover != null && !(block instanceof EntityBlock)) {
                    tile.cover = cover;
                    Utility.sendBlockEntityToClients(tile);
                    offhand.m_41774_(1);
                    world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        for (Map.Entry<Direction, VoxelShape> entry : PipeBlock.DIR_SHAPES.entrySet()) {
            EnumProperty<ConnectionType> prop;
            ConnectionType curr;
            AABB box = entry.getValue().m_83215_().m_82338_(pos).m_82400_((double)0.001f);
            if (!box.m_82390_(context.m_43720_()) || (curr = (ConnectionType)((Object)state.m_61143_(prop = PipeBlock.DIRECTIONS.get(entry.getKey())))) == ConnectionType.DISCONNECTED) continue;
            if (!world.f_46443_) {
                ConnectionType newType = curr == ConnectionType.BLOCKED ? ConnectionType.CONNECTED : ConnectionType.BLOCKED;
                BlockPos otherPos = pos.m_121945_(entry.getKey());
                BlockState otherState = world.m_8055_(otherPos);
                if (otherState.m_60734_() instanceof PipeBlock) {
                    otherState = (BlockState)otherState.m_61124_((Property)PipeBlock.DIRECTIONS.get(entry.getKey().m_122424_()), (Comparable)((Object)newType));
                    world.m_46597_(otherPos, otherState);
                    PipeBlock.onStateChanged(world, otherPos, otherState);
                }
                BlockState newState = (BlockState)state.m_61124_(prop, (Comparable)((Object)newType));
                world.m_46597_(pos, newState);
                PipeBlock.onStateChanged(world, pos, newState);
                world.m_5594_(null, pos, SoundEvents.f_12017_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Utility.addTooltip(ForgeRegistries.ITEMS.getKey((Object)this).m_135815_(), tooltip);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44985_;
    }
}

