/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public final class Utility {
    public static <T extends BlockEntity> T getBlockEntity(Class<T> type, BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static void dropInventory(BlockEntity tile, IItemHandler inventory) {
        BlockPos pos = tile.m_58899_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)tile.m_58904_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public static Direction getDirectionFromOffset(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.m_121996_((Vec3i)other);
        return Direction.m_122378_((int)diff.m_123341_(), (int)diff.m_123342_(), (int)diff.m_123343_());
    }

    public static void addTooltip(String name, List<Component> tooltip) {
        if (Screen.m_96638_()) {
            String[] content;
            for (String s : content = I18n.m_118938_((String)("info.prettypipes." + name), (Object[])new Object[0]).split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)s).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.prettypipes.shift").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GRAY)));
        }
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, IMergeItemStack merge, Player player, int slotIndex, Function<ItemStack, Pair<Integer, Integer>> predicate) {
        int inventoryStart = (int)container.f_38839_.stream().filter(slot -> slot.f_40218_ != player.m_150109_()).count();
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot slot2 = (Slot)container.f_38839_.get(slotIndex);
        if (slot2 != null && slot2.m_6657_()) {
            Pair<Integer, Integer> slots;
            ItemStack newStack = slot2.m_7993_();
            ItemStack currentStack = newStack.m_41777_();
            if (slotIndex >= inventoryStart ? ((slots = predicate.apply(newStack)) != null ? !merge.mergeItemStack(newStack, (Integer)slots.getLeft(), (Integer)slots.getRight(), false) : (slotIndex >= inventoryStart && slotIndex <= inventoryEnd ? !merge.mergeItemStack(newStack, hotbarStart, hotbarEnd + 1, false) : slotIndex >= inventoryEnd + 1 && slotIndex < hotbarEnd + 1 && !merge.mergeItemStack(newStack, inventoryStart, inventoryEnd + 1, false))) : !merge.mergeItemStack(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (newStack.m_41619_()) {
                slot2.m_5852_(ItemStack.f_41583_);
            } else {
                slot2.m_6654_();
            }
            if (newStack.m_41613_() == currentStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot2.m_142406_(player, newStack);
            return currentStack;
        }
        return ItemStack.f_41583_;
    }

    public static ListTag serializeAll(Collection<? extends INBTSerializable<CompoundTag>> items) {
        ListTag list = new ListTag();
        for (INBTSerializable<CompoundTag> iNBTSerializable : items) {
            list.add((Object)iNBTSerializable.serializeNBT());
        }
        return list;
    }

    public static void sendBlockEntityToClients(BlockEntity tile) {
        ServerLevel world = (ServerLevel)tile.m_58904_();
        List entities = world.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false);
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)tile, BlockEntity::m_187482_);
        for (ServerPlayer e : entities) {
            e.f_8906_.m_9829_((Packet)packet);
        }
    }

    public static <T extends INBTSerializable<CompoundTag>> List<T> deserializeAll(ListTag list, Function<CompoundTag, T> supplier) {
        ArrayList<INBTSerializable> items = new ArrayList<INBTSerializable>();
        for (int i = 0; i < list.size(); ++i) {
            INBTSerializable item = (INBTSerializable)supplier.apply(list.m_128728_(i));
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public static IItemHandler getBlockItemHandler(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof WorldlyContainerHolder)) {
            return null;
        }
        WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
        WorldlyContainer inventory = holder.m_5840_(state, (LevelAccessor)world, pos);
        if (inventory == null) {
            return null;
        }
        return new SidedInvWrapper(inventory, direction);
    }

    public static interface IMergeItemStack {
        public boolean mergeItemStack(ItemStack var1, int var2, int var3, boolean var4);
    }
}

