/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public class InceptionInventoryHandler
implements ITrackedContentsItemHandler {
    private IItemHandlerModifiable combinedInventories;
    private final ITrackedContentsItemHandler wrappedInventoryHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private List<ITrackedContentsItemHandler> handlers;
    private int[] baseIndex;

    public InceptionInventoryHandler(ITrackedContentsItemHandler wrappedInventoryHandler, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedInventoryHandler = wrappedInventoryHandler;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlerDelegate());
        this.refreshHandlerDelegate();
    }

    private void refreshHandlerDelegate() {
        this.handlers = new ArrayList<ITrackedContentsItemHandler>();
        if (this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> this.handlers.add(sbp.getInventoryForInputOutput()));
        if (this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.combinedInventories = new CombinedInvWrapper(this.handlers.toArray(new IItemHandlerModifiable[0]));
        this.baseIndex = new int[this.handlers.size()];
        int index = 0;
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.baseIndex[i] = index += this.handlers.get(i).getSlots();
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.combinedInventories.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.combinedInventories.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.combinedInventories.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.combinedInventories.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.combinedInventories.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.combinedInventories.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.combinedInventories.isItemValid(slot, stack);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        IItemHandlerSimpleInserter handler;
        ItemStack remainingStack = stack;
        Iterator<ITrackedContentsItemHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext() && !(remainingStack = (handler = (IItemHandlerSimpleInserter)iterator.next()).insertItem(remainingStack, simulate)).m_41619_()) {
        }
        return remainingStack;
    }

    public Set<ItemStackKey> getTrackedStacks() {
        HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>();
        this.handlers.forEach(h -> ret.addAll(h.getTrackedStacks()));
        return ret;
    }

    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.handlers.forEach(h -> h.registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot));
    }

    public void unregisterStackKeyListeners() {
        this.handlers.forEach(ITrackedContentsItemHandler::unregisterStackKeyListeners);
    }

    public boolean hasEmptySlots() {
        return this.handlers.stream().anyMatch(ITrackedContentsItemHandler::hasEmptySlots);
    }

    public int getInternalSlotLimit(int slot) {
        int index = this.getIndexForSlot(slot);
        ITrackedContentsItemHandler handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.getInternalSlotLimit(localSlot);
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    private int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    private ITrackedContentsItemHandler getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.handlers.size()) {
            return this.handlers.get(0);
        }
        return this.handlers.get(index);
    }
}

