/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.containers;

import com.direwolf20.buildinggadgets.common.containers.BaseContainer;
import com.direwolf20.buildinggadgets.common.containers.OurContainers;
import com.direwolf20.buildinggadgets.common.tileentities.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TemplateManagerContainer
extends BaseContainer {
    public static final String TEXTURE_LOC_SLOT_TOOL = "buildinggadgets:gui/slot_copy_paste_gadget";
    public static final String TEXTURE_LOC_SLOT_TEMPLATE = "buildinggadgets:gui/slot_template";
    private TemplateManagerTileEntity te;

    public TemplateManagerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        super((MenuType)OurContainers.TEMPLATE_MANAGER_CONTAINER.get(), windowId);
        BlockPos pos = extraData.m_130135_();
        this.te = (TemplateManagerTileEntity)playerInventory.f_35978_.f_19853_.m_7702_(pos);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory, -12, 70);
    }

    public TemplateManagerContainer(int windowId, Inventory playerInventory, TemplateManagerTileEntity tileEntity) {
        super((MenuType)OurContainers.TEMPLATE_MANAGER_CONTAINER.get(), windowId);
        this.te = Objects.requireNonNull(tileEntity);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory, -12, 70);
    }

    public boolean m_6875_(Player playerIn) {
        return this.getTe().canInteractWith(playerIn);
    }

    private void addOwnSlots() {
        IItemHandler itemHandler = (IItemHandler)this.getTe().getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(CapabilityNotPresentException::new);
        int x = 132;
        this.m_38897_((Slot)new SlotTemplateManager(itemHandler, 0, x, 18, TEXTURE_LOC_SLOT_TOOL));
        this.m_38897_((Slot)new SlotTemplateManager(itemHandler, 1, x, 63, TEXTURE_LOC_SLOT_TEMPLATE));
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack currentStack = slot.m_7993_();
            itemstack = currentStack.m_41777_();
            if (index < 2 ? !this.m_38903_(currentStack, 2, this.f_38839_.size(), true) : !this.m_38903_(currentStack, 0, 2, false)) {
                return ItemStack.f_41583_;
            }
            if (currentStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public TemplateManagerTileEntity getTe() {
        return this.te;
    }

    public static class SlotTemplateManager
    extends SlotItemHandler {
        private String backgroundLoc;

        public SlotTemplateManager(IItemHandler itemHandler, int index, int xPosition, int yPosition, String backgroundLoc) {
            super(itemHandler, index, xPosition, yPosition);
            this.backgroundLoc = backgroundLoc;
        }

        public Slot setBackground(ResourceLocation atlas, ResourceLocation sprite) {
            return super.setBackground(atlas, new ResourceLocation("buildinggadgets", this.backgroundLoc));
        }

        public int m_6641_() {
            return 1;
        }
    }
}

