/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamresourceful.resourcefullib.common.yabn.YabnCompressor;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnArray;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnObject;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnPrimitive;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.BooleanContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.ByteContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.DoubleContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.FloatContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.IntContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.LongContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NullContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.PrimitiveContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.ShortContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.StringContents;
import java.math.BigDecimal;

public final class YabnConverter {
    private YabnConverter() {
    }

    public static YabnElement fromJson(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            YabnObject object = new YabnObject();
            obj.entrySet().forEach(entry -> object.put((String)entry.getKey(), YabnConverter.fromJson((JsonElement)entry.getValue())));
            return object;
        }
        if (json instanceof JsonArray) {
            JsonArray arr = (JsonArray)json;
            YabnArray array = new YabnArray();
            arr.forEach(element -> array.add(YabnConverter.fromJson(element)));
            return array;
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isString()) {
                return YabnPrimitive.ofString(primitive.getAsString());
            }
            if (primitive.isBoolean()) {
                return YabnPrimitive.ofBoolean(primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                BigDecimal value = primitive.getAsBigDecimal();
                try {
                    return YabnCompressor.compressNonFloatingNumber(value.longValueExact());
                }
                catch (ArithmeticException e) {
                    return YabnCompressor.compressFloatingNumber(value.doubleValue());
                }
            }
        } else if (json.isJsonNull()) {
            return NullContents.NULL;
        }
        throw new IllegalArgumentException("Unsupported json element type: " + json.getClass().getName());
    }

    public static JsonElement toJson(YabnElement json) {
        if (json instanceof YabnObject) {
            YabnObject obj = (YabnObject)json;
            JsonObject jsonObject = new JsonObject();
            obj.elements().forEach((key, value) -> jsonObject.add(key, YabnConverter.toJson(value)));
            return jsonObject;
        }
        if (json instanceof YabnArray) {
            YabnArray arr = (YabnArray)json;
            JsonArray jsonArray = new JsonArray();
            arr.elements().forEach(element -> jsonArray.add(YabnConverter.toJson(element)));
            return jsonArray;
        }
        if (json instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)json;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof BooleanContents) {
                BooleanContents boolContents = (BooleanContents)contents;
                return new JsonPrimitive(Boolean.valueOf(boolContents.value()));
            }
            if (contents instanceof ByteContents) {
                ByteContents byteContents = (ByteContents)contents;
                return new JsonPrimitive((Number)byteContents.value());
            }
            if (contents instanceof DoubleContents) {
                DoubleContents doubleContents = (DoubleContents)contents;
                return new JsonPrimitive((Number)doubleContents.value());
            }
            if (contents instanceof FloatContents) {
                FloatContents floatContents = (FloatContents)contents;
                return new JsonPrimitive((Number)Float.valueOf(floatContents.value()));
            }
            if (contents instanceof IntContents) {
                IntContents intContents = (IntContents)contents;
                return new JsonPrimitive((Number)intContents.value());
            }
            if (contents instanceof LongContents) {
                LongContents longContents = (LongContents)contents;
                return new JsonPrimitive((Number)longContents.value());
            }
            if (contents instanceof ShortContents) {
                ShortContents shortContents = (ShortContents)contents;
                return new JsonPrimitive((Number)shortContents.value());
            }
            if (contents instanceof StringContents) {
                StringContents stringContents = (StringContents)contents;
                return new JsonPrimitive(stringContents.value());
            }
            if (contents instanceof NullContents) {
                return JsonNull.INSTANCE;
            }
            throw new IllegalArgumentException("Unknown primitive contents type: " + contents.getClass().getName());
        }
        throw new IllegalArgumentException("Unknown YABN element type: " + json.getClass().getName());
    }
}

