/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.levelgen;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;
import se.mickelus.tetra.items.cell.ThermalCellItem;

@ParametersAreNonnullByDefault
public class ForgedHammerProcessor
extends StructureProcessor {
    public static final ForgedHammerProcessor INSTANCE = new ForgedHammerProcessor();
    public static final Codec<ForgedHammerProcessor> codec = Codec.unit(() -> INSTANCE);
    public static RegistryObject<StructureProcessorType<?>> type;

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo $, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo.f_74676_.m_60734_() instanceof HammerBaseBlock) {
            RandomSource random = placementSettings.m_230326_(blockInfo.f_74675_);
            CompoundTag newCompound = blockInfo.f_74677_.m_6426_();
            ItemStack cell1 = random.m_188499_() ? new ItemStack((ItemLike)ThermalCellItem.instance.get()) : null;
            ItemStack cell2 = random.m_188499_() ? new ItemStack((ItemLike)ThermalCellItem.instance.get()) : null;
            int charge1 = random.m_188503_(128);
            if (cell1 != null) {
                ThermalCellItem.recharge(cell1, charge1);
            }
            int charge2 = 128 - random.m_188503_(Math.max(charge1, 1));
            if (cell2 != null) {
                ThermalCellItem.recharge(cell2, charge2);
            }
            HammerBaseBlockEntity.writeCells(newCompound, cell1, cell2);
            HammerEffect module = HammerEffect.efficient;
            if ((double)random.m_188501_() < 0.1) {
                module = HammerEffect.reliable;
            } else if ((double)random.m_188501_() < 0.1) {
                HammerEffect hammerEffect = module = random.m_188499_() ? HammerEffect.precise : HammerEffect.power;
            }
            if (random.m_188499_()) {
                HammerBaseBlockEntity.writeModules(newCompound, module, null);
            } else {
                HammerBaseBlockEntity.writeModules(newCompound, null, module);
            }
            return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_, blockInfo.f_74676_, newCompound);
        }
        return blockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)type.get();
    }
}

