/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.apache.commons.lang3.tuple.Pair;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.SweepingStrikeEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class StrikingEffect {
    public static final List<Pair<ItemEffect, ToolAction>> effectActionMap = ImmutableList.of((Object)Pair.of((Object)ItemEffect.strikingAxe, (Object)ToolActions.AXE_DIG), (Object)Pair.of((Object)ItemEffect.strikingPickaxe, (Object)ToolActions.PICKAXE_DIG), (Object)Pair.of((Object)ItemEffect.strikingCut, (Object)TetraToolActions.cut), (Object)Pair.of((Object)ItemEffect.strikingShovel, (Object)ToolActions.SHOVEL_DIG), (Object)Pair.of((Object)ItemEffect.strikingHoe, (Object)ToolActions.HOE_DIG));

    public static boolean causeEffect(Player breakingPlayer, ItemStack itemStack, ItemModularHandheld item, Level world, BlockPos pos, BlockState blockState) {
        int strikingLevel = 0;
        ToolAction tool = null;
        if (breakingPlayer.m_21023_(MobEffects.f_19599_)) {
            return false;
        }
        for (Pair<ItemEffect, ToolAction> entry : effectActionMap) {
            if (!ToolActionHelper.isEffectiveOn((ToolAction)entry.getRight(), blockState) || (strikingLevel = EffectHelper.getEffectLevel(itemStack, (ItemEffect)entry.getLeft())) <= 0) continue;
            tool = (ToolAction)entry.getRight();
            break;
        }
        if (strikingLevel > 0) {
            if ((double)breakingPlayer.m_36403_(0.0f) > 0.9 && blockState.m_60800_((BlockGetter)world, pos) != -1.0f) {
                if (EffectHelper.getEffectLevel(itemStack, ItemEffect.sweepingStrike) > 0) {
                    SweepingStrikeEffect.causeEffect(world, breakingPlayer, itemStack, pos, tool);
                } else if (ToolActionHelper.playerCanDestroyBlock(breakingPlayer, blockState, pos, itemStack)) {
                    EffectHelper.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
                    item.applyUsageEffects((LivingEntity)breakingPlayer, itemStack, 1.0);
                    item.applyDamage(item.getBlockDestroyDamage(), itemStack, (LivingEntity)breakingPlayer);
                }
            }
            breakingPlayer.m_36334_();
            return true;
        }
        return false;
    }
}

