/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.blocks.scroll.OpenScrollBlock;
import se.mickelus.tetra.blocks.scroll.RolledScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollDrops;
import se.mickelus.tetra.blocks.scroll.ScrollItemColor;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.scroll.WallScrollBlock;
import se.mickelus.tetra.blocks.scroll.gui.ScrollScreen;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.items.InitializableItem;
import se.mickelus.tetra.items.TetraItemGroup;

@ParametersAreNonnullByDefault
public class ScrollItem
extends BlockItem
implements InitializableItem {
    public static final String identifier = "scroll_rolled";
    @ObjectHolder(registryName="item", value="tetra:scroll_rolled")
    public static ScrollItem instance;
    public static ItemStack gemExpertise;
    public static ItemStack metalExpertise;
    public static ItemStack woodExpertise;
    public static ItemStack stoneExpertise;
    public static ItemStack fibreExpertise;
    public static ItemStack skinExpertise;
    public static ItemStack boneExpertise;
    public static ItemStack fabricExpertise;
    public static ItemStack scaleExpertise;
    public static ItemStack hammerEfficiency;
    public static ItemStack axeEfficiency;
    public static ItemStack cutEfficiency;
    public static ItemStack sturdyGuard;
    public static ItemStack throwingKnife;
    public static ItemStack howlingBlade;

    public ScrollItem(Block block) {
        super(block, new Item.Properties().m_41491_((CreativeModeTab)TetraItemGroup.instance).m_41487_(1));
        MinecraftForge.EVENT_BUS.register((Object)new ScrollDrops());
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        gemExpertise = this.setupTreatise("gem_expertise", false, 0, 2883566, 14, 13, 14, 15);
        metalExpertise = this.setupTreatise("metal_expertise", false, 0, 0xFFFFFF, 4, 6, 6, 5);
        woodExpertise = this.setupTreatise("wood_expertise", false, 0, 12555083, 2, 1, 2, 1);
        stoneExpertise = this.setupTreatise("stone_expertise", false, 0, 0x9A9A9A, 2);
        fibreExpertise = this.setupTreatise("fibre_expertise", false, 0, 11042900, 5, 10, 11, 4);
        skinExpertise = this.setupTreatise("skin_expertise", false, 0, 12544304, 0, 1, 1, 1);
        boneExpertise = this.setupTreatise("bone_expertise", false, 0, 16773523, 12, 14, 12, 14);
        fabricExpertise = this.setupTreatise("fabric_expertise", false, 0, 0xFF3333, 5, 3, 6, 4);
        scaleExpertise = this.setupTreatise("scale_expertise", false, 0, 7708734, 6, 7, 6, 8);
        hammerEfficiency = this.setupTreatise("hammer_efficiency", false, 0, 0xFF6666, 6, 7, 6, 11);
        axeEfficiency = this.setupTreatise("axe_efficiency", false, 0, 0x66FF66, 0, 1, 3, 3);
        cutEfficiency = this.setupTreatise("cut_efficiency", false, 0, 0x6666FF, 4, 0, 3, 5);
        sturdyGuard = this.setupSchematic("sword/sturdy_guard", null, false, 1, 12368053, 3, 2, 2, 1);
        throwingKnife = this.setupSchematic("sword/throwing_knife", null, false, 1, 12111577, 4, 1, 0, 5);
        howlingBlade = this.setupSchematic("sword/howling", null, false, 1, 16446358, 8, 9, 10, 5);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        Minecraft.m_91087_().getItemColors().m_92689_((ItemColor)new ScrollItemColor(), new ItemLike[]{instance});
        ItemProperties.register((Item)instance, (ResourceLocation)new ResourceLocation("tetra", "scroll_mat"), (itemStack, world, livingEntity, i) -> ScrollData.readMaterialFast(itemStack));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)gemExpertise);
            items.add((Object)metalExpertise);
            items.add((Object)woodExpertise);
            items.add((Object)stoneExpertise);
            items.add((Object)fibreExpertise);
            items.add((Object)skinExpertise);
            items.add((Object)boneExpertise);
            items.add((Object)fabricExpertise);
            items.add((Object)scaleExpertise);
            items.add((Object)hammerEfficiency);
            items.add((Object)axeEfficiency);
            items.add((Object)cutEfficiency);
            items.add((Object)sturdyGuard);
            items.add((Object)throwingKnife);
            items.add((Object)howlingBlade);
            items.add((Object)this.setupSchematic("warforge/adze", "warforge", false, 2, 8739251, 6, 7, 11, 7));
            items.add((Object)this.setupSchematic("warforge/axe", "warforge", false, 2, 11753843, 5, 10, 8, 9));
            items.add((Object)this.setupSchematic("warforge/hammer", "warforge", false, 2, 4014745, 9, 8, 11, 10));
            items.add((Object)this.setupSchematic("warforge/pickaxe", "warforge", false, 2, 5278899, 6, 11, 8, 7));
            items.add((Object)this.setupSchematic("warforge/claw", "warforge", false, 2, 1910319, 8, 10, 5, 11));
            items.add((Object)this.setupSchematic("warforge/hoe", "warforge", false, 2, 9679696, 10, 7, 9, 5));
            items.add((Object)this.setupSchematic("warforge/sickle", "warforge", false, 2, 14261836, 5, 9, 6, 10));
            items.add((Object)this.setupSchematic("warforge/butt", "warforge", false, 2, 0xB33636, 11, 5, 8, 9));
            items.add((Object)this.setupSchematic("hone/gild_1", null, true, 2, 13217385, 15, 14, 15, 15));
            items.add((Object)this.setupSchematic("hone/gild_5", null, new String[]{"hone/gild_1", "hone/gild_2", "hone/gild_3", "hone/gild_4", "hone/gild_5"}, true, 2, 15905555, 12, 12, 12, 12));
        }
    }

    private ItemStack setupSchematic(String key, String details, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        return this.setupSchematic(key, details, new String[]{key}, isIntricate, material, tint, glyphs);
    }

    private ItemStack setupSchematic(String key, String details, String[] schematics, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        ScrollData data = new ScrollData(key, Optional.ofNullable(details), isIntricate, material, tint, Arrays.asList(glyphs), Arrays.stream(schematics).map(s -> new ResourceLocation("tetra", s)).collect(Collectors.toList()), Collections.emptyList());
        ItemStack itemStack = new ItemStack((ItemLike)this);
        data.write(itemStack);
        return itemStack;
    }

    private ItemStack setupTreatise(String key, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        ScrollData data = new ScrollData(key, Optional.empty(), isIntricate, material, tint, Arrays.asList(glyphs), Collections.emptyList(), (List<ResourceLocation>)ImmutableList.of((Object)new ResourceLocation("tetra", key)));
        ItemStack itemStack = new ItemStack((ItemLike)this);
        data.write(itemStack);
        return itemStack;
    }

    public Component m_7626_(ItemStack stack) {
        String prefixKey;
        String key = ScrollData.read((ItemStack)stack).key;
        if (!Environment.get().getDist().isDedicatedServer() && I18n.m_118936_((String)(prefixKey = "item.tetra.scroll." + key + ".prefix"))) {
            return Component.m_237115_((String)("item.tetra.scroll." + key + ".prefix")).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)("item.tetra.scroll." + key + ".name")));
        }
        return Component.m_237115_((String)("item.tetra.scroll." + key + ".name"));
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ScrollData data = ScrollData.read(itemStack);
        StringJoiner attributes = new StringJoiner(" ");
        if (!ScrollData.read((ItemStack)itemStack).schematics.isEmpty()) {
            attributes.add(ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"item.tetra.scroll.schematics", (Object[])new Object[0]));
        }
        if (!ScrollData.read((ItemStack)itemStack).craftingEffects.isEmpty()) {
            attributes.add(ChatFormatting.DARK_AQUA + I18n.m_118938_((String)"item.tetra.scroll.effects", (Object[])new Object[0]));
        }
        if (data.isIntricate) {
            attributes.add(ChatFormatting.GOLD + I18n.m_118938_((String)"item.tetra.scroll.intricate", (Object[])new Object[0]));
        }
        tooltip.add((Component)Component.m_237113_((String)attributes.toString()));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)("item.tetra.scroll." + data.key + ".description")).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)" "));
        if (Screen.m_96638_()) {
            tooltip.add(Tooltips.expanded);
            if (!ScrollData.read((ItemStack)itemStack).schematics.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)" "));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.schematics").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.DARK_PURPLE}));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.schematics.description").m_130940_(ChatFormatting.GRAY));
            }
            if (!ScrollData.read((ItemStack)itemStack).craftingEffects.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)" "));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.effects").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.DARK_AQUA}));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.effects.description").m_130940_(ChatFormatting.GRAY));
            }
            if (data.isIntricate) {
                tooltip.add((Component)Component.m_237113_((String)" "));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.intricate").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD}));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.intricate.description").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237113_((String)" "));
                tooltip.add((Component)Component.m_237115_((String)"item.tetra.scroll.range.description").m_130940_(ChatFormatting.GRAY));
            }
            if (I18n.m_118936_((String)("item.tetra.scroll." + data.key + ".description_extended"))) {
                tooltip.add((Component)Component.m_237113_((String)" "));
                tooltip.add((Component)Component.m_237115_((String)("item.tetra.scroll." + data.key + ".description_extended")).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add(Tooltips.expand);
        }
        if (flagIn.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)("s: " + data.schematics + ",e: " + data.craftingEffects)));
        }
    }

    private boolean openScroll(ItemStack itemStack, boolean isRemote) {
        ScrollData data = ScrollData.read(itemStack);
        if (data.details != null) {
            if (isRemote) {
                this.showDetailsScreen(data.details);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showDetailsScreen(String detailsKey) {
        ScrollScreen screen = new ScrollScreen(detailsKey);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.openScroll(player.m_21120_(hand), world.f_46443_)) {
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean success;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
        if (!(block instanceof AbstractWorkbenchBlock) && player != null && player.m_6047_() && this.openScroll(itemStack, world.f_46443_)) {
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (RolledScrollBlock.instance.equals(block) && (success = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ScrollTile.class).map(tile -> tile.addScroll(itemStack)).orElse(false).booleanValue())) {
            if (player == null || !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return this.m_40576_(new BlockPlaceContext(context));
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        BlockState state = this.m_40614_().m_49966_();
        if (context.m_43719_().m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            state = (BlockState)WallScrollBlock.instance.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_43719_());
        } else {
            if (context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_())).m_60734_() instanceof AbstractWorkbenchBlock) {
                state = OpenScrollBlock.instance.m_49966_();
            }
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_());
        }
        return this.m_40610_(context, state) ? state : null;
    }
}

