/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
public class QuadRenderer {
    public final Vertex[] vertexPositions;
    public final Vector3f normal;

    public QuadRenderer(float x, float y, float z, float w, float h, float u, float v, float texWidth, float texHeight, boolean mirror, Direction direction) {
        float u1 = u / texWidth;
        float u2 = (u + w) / texWidth;
        float v1 = v / texHeight;
        float v2 = (v + h) / texHeight;
        if (mirror) {
            float temp = u1;
            u1 = u2;
            u2 = temp;
        }
        switch (direction) {
            default: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + w, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + w, y + 0.0f, z + h, u2, v2), new Vertex(x + 0.0f, y + 0.0f, z + h, u1, v2)};
                break;
            }
            case UP: {
                this.vertexPositions = new Vertex[]{new Vertex(x + w, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + 0.0f, y + 0.0f, z + h, u2, v2), new Vertex(x + w, y + 0.0f, z + h, u1, v2)};
                break;
            }
            case WEST: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + w, u2, v1), new Vertex(x + 0.0f, y + h, z + w, u2, v2), new Vertex(x + 0.0f, y + h, z + 0.0f, u1, v2)};
                break;
            }
            case NORTH: {
                this.vertexPositions = new Vertex[]{new Vertex(x + w, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + 0.0f, y + h, z + 0.0f, u2, v2), new Vertex(x + w, y + h, z + 0.0f, u1, v2)};
                break;
            }
            case EAST: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + w, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + 0.0f, y + h, z + 0.0f, u2, v2), new Vertex(x + 0.0f, y + h, z + w, u1, v2)};
                break;
            }
            case SOUTH: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + w, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + w, y + h, z + 0.0f, u2, v2), new Vertex(x + 0.0f, y + h, z + 0.0f, u1, v2)};
            }
        }
        this.normal = direction.m_122432_();
        if (mirror) {
            this.normal.m_122263_(-1.0f, 1.0f, 1.0f);
        }
    }

    public void render(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        PoseStack.Pose last = matrixStack.m_85850_();
        Matrix4f matrix = last.m_85861_();
        Matrix3f normal = last.m_85864_();
        Vector3f vector3f = this.normal.m_122281_();
        vector3f.m_122249_(normal);
        float originX = vector3f.m_122239_();
        float originY = vector3f.m_122260_();
        float originZ = vector3f.m_122269_();
        for (Vertex vertex : this.vertexPositions) {
            Vector4f pos = new Vector4f(vertex.pos.m_122239_() / 16.0f, vertex.pos.m_122260_() / 16.0f, vertex.pos.m_122269_() / 16.0f, 1.0f);
            pos.m_123607_(matrix);
            buffer.m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), red, green, blue, alpha, vertex.u, vertex.v, packedOverlay, packedLight, originX, originY, originZ);
        }
        matrixStack.m_85849_();
    }

    static class Vertex {
        final Vector3f pos;
        final float u;
        final float v;

        public Vertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public Vertex(Vector3f pos, float u, float v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }
}

