/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.gui.GuiTool;
import se.mickelus.tetra.properties.PropertyHelper;

@ParametersAreNonnullByDefault
public class InteractiveToolGui
extends GuiElement {
    private final GuiTool toolIcon;
    private final KeyframeAnimation hide;
    private final ToolAction toolAction;
    private final int toolLevel;
    private final Player player;
    private KeyframeAnimation show;
    private int currentSlot;

    public InteractiveToolGui(int x, int y, ToolAction toolAction, int toolLevel, Player player) {
        super(x, y, 16, 16);
        this.opacity = 0.0f;
        this.toolAction = toolAction;
        this.toolLevel = toolLevel;
        this.player = player;
        this.toolIcon = new GuiTool(-1, 0, toolAction);
        this.addChild(this.toolIcon);
        this.show = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f)}).withDelay(650);
        this.hide = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f)});
        this.updateTint();
        this.currentSlot = player.m_150109_().f_35977_;
    }

    public void updateFadeTime() {
        this.show = this.show.withDelay(0);
    }

    private void updateTint() {
        int mainHandLevel = PropertyHelper.getItemToolLevel(this.player.m_21205_(), this.toolAction);
        int offHandLevel = PropertyHelper.getItemToolLevel(this.player.m_21206_(), this.toolAction);
        if (mainHandLevel >= this.toolLevel || offHandLevel >= this.toolLevel) {
            this.toolIcon.update(this.toolLevel, 0xFFFFFF);
        } else if (PropertyHelper.getPlayerToolLevel(this.player, this.toolAction) >= this.toolLevel) {
            this.toolIcon.update(this.toolLevel, 0xFFFF00);
        } else {
            this.toolIcon.update(this.toolLevel, 0xFF5555);
        }
    }

    public void show() {
        this.updateTint();
        this.hide.stop();
        this.show.start();
    }

    public void hide() {
        this.show.stop();
        this.hide.start();
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.player.m_150109_().f_35977_ != this.currentSlot) {
            this.updateTint();
            this.currentSlot = this.player.m_150109_().f_35977_;
        }
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
    }
}

