/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.holo;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.holo.HolosphereBlockEntity;
import se.mickelus.tetra.blocks.holo.HolosphereEntityRenderer;
import se.mickelus.tetra.blocks.holo.ToggleScanModeInteraction;
import se.mickelus.tetra.interactions.SecondaryInteractionHandler;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;

public class HolosphereBlock
extends TetraWaterloggedBlock
implements EntityBlock {
    public static final String identifier = "holosphere";
    private static final VoxelShape shape = Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5);
    public static RegistryObject<HolosphereBlock> instance;

    public HolosphereBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.0f, 20.0f).m_60918_(SoundType.f_154677_));
    }

    public static InteractionResult place(BlockPlaceContext context) {
        if (context.m_7059_()) {
            Block block = (Block)instance.get();
            BlockState blockState = block.m_49966_();
            boolean couldPlace = context.m_43725_().m_7731_(context.m_8083_(), blockState, 11);
            if (couldPlace) {
                BlockPos pos = context.m_8083_();
                Level level = context.m_43725_();
                Player player = context.m_43723_();
                ItemStack itemstack = context.m_43722_();
                BlockState placedBlockState = level.m_8055_(pos);
                if (placedBlockState.m_60713_(blockState.m_60734_())) {
                    level.m_141902_(pos, (BlockEntityType)HolosphereBlockEntity.type.get()).ifPresent(blockEntity -> blockEntity.setItemTag(itemstack.m_41783_()));
                    placedBlockState.m_60734_().m_6402_(level, pos, placedBlockState, (LivingEntity)player, itemstack);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, itemstack);
                    }
                }
                level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)placedBlockState));
                SoundType soundtype = placedBlockState.getSoundType((LevelReader)level, pos, (Entity)context.m_43723_());
                level.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                if (player == null || !player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        SecondaryInteractionHandler.registerInteraction(new ToggleScanModeInteraction("scan_toggle_on", true));
        SecondaryInteractionHandler.registerInteraction(new ToggleScanModeInteraction("scan_toggle_off", false));
    }

    @Override
    public void clientInit() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)HolosphereBlockEntity.type.get()), HolosphereEntityRenderer::new);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new HolosphereBlockEntity(p_153215_, p_153216_);
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemModularHandheld item;
        int level;
        HolosphereBlockEntity entity;
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof HolosphereBlockEntity && (entity = (HolosphereBlockEntity)blockEntity).inScanMode() && (blockEntity = itemStack.m_41720_()) instanceof ItemModularHandheld && (level = (item = (ItemModularHandheld)blockEntity).getToolLevel(itemStack, TetraToolActions.hammer)) > 0) {
            boolean canSwing;
            boolean bl = canSwing = player.m_36403_(0.0f) > 0.8f;
            if (!world.m_5776_() && canSwing) {
                float angle = (float)RotationHelper.getHorizontalAngle((Vec3)Vec3.m_82539_((Vec3i)pos), (Vec3)player.m_20182_());
                entity.use(level, item.getToolEfficiency(itemStack, TetraToolActions.hammer), angle);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("percussion_scan", "true");
                BlockUseCriterion.trigger((ServerPlayer)player, blockState, itemStack, data);
            }
            if (canSwing) {
                item.tickProgression((LivingEntity)player, itemStack, 2);
                item.applyDamage(2, itemStack, (LivingEntity)player);
                world.m_5594_(player, pos, SoundEvents.f_12201_, SoundSource.PLAYERS, 0.3f, 1.0f + 0.5f * (float)Math.random());
            } else {
                world.m_5594_(player, pos, SoundEvents.f_12473_, SoundSource.PLAYERS, 0.2f, 0.5f);
            }
            player.m_36334_();
            return InteractionResult.m_19078_((boolean)canSwing);
        }
        if (world.m_5776_()) {
            ModularHolosphereItem.showGui();
        } else {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("holosphere_open", "true");
            BlockUseCriterion.trigger((ServerPlayer)player, blockState, itemStack, data);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        if (!world.f_46443_ && !player.m_7500_() && world.m_46469_().m_46207_(GameRules.f_46136_)) {
            world.m_141902_(pos, (BlockEntityType)HolosphereBlockEntity.type.get()).ifPresent(blockEntity -> {
                ItemStack itemStack = blockEntity.getItemStack();
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            });
        }
    }
}

