/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.main;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.MainSetting;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.settings.main.Context;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory;

public class MainSettingsContainer
extends SettingsContainerBase<MainSettingsCategory> {
    private static final String CONTEXT_TAG = "context";
    private Context context = Context.PLAYER;

    public MainSettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, MainSettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(CONTEXT_TAG)) {
            this.context = Context.fromId(data.m_128451_(CONTEXT_TAG));
        } else {
            for (String tagName : data.m_128431_()) {
                SettingsManager.getSetting(tagName).ifPresent(setting -> this.setSettingValue(this.getPlayer(), (MainSetting)setting, data));
            }
        }
    }

    public void toggleContext() {
        this.context = this.context == Context.PLAYER ? Context.STORAGE : Context.PLAYER;
        this.sendIntToServer(CONTEXT_TAG, this.context.getId());
    }

    public Context getContext() {
        return this.context;
    }

    protected Player getPlayer() {
        return this.getSettingsContainer().getPlayer();
    }

    public void toggleShiftClickIntoOpenTab() {
        this.toggleBooleanSetting(this.getPlayer(), SettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    public boolean shouldShiftClickIntoOpenTab() {
        return this.getSettingValue(SettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    public void toggleKeepTabOpen() {
        this.toggleBooleanSetting(this.getPlayer(), SettingsManager.KEEP_TAB_OPEN);
    }

    public boolean shouldKeepTabOpen() {
        return this.getSettingValue(SettingsManager.KEEP_TAB_OPEN);
    }

    protected <S> S getSettingValue(MainSetting<S> setting) {
        if (this.context == Context.PLAYER) {
            return SettingsManager.getPlayerSettingOrDefault(this.getPlayer(), ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), setting);
        }
        return SettingsManager.getSettingValue(this.getPlayer(), ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), (MainSettingsCategory)this.getCategory(), setting);
    }

    private <S> void setSettingValue(Player player, MainSetting<S> setting, CompoundTag data) {
        setting.getValue(data).ifPresent(value -> {
            if (this.context == Context.PLAYER) {
                SettingsManager.setPlayerSetting(player, ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), setting, value);
            } else {
                SettingsManager.setSetting(player, ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), (MainSettingsCategory)this.getCategory(), setting, value);
            }
        });
    }

    protected void toggleBooleanSetting(Player player, MainSetting<Boolean> setting) {
        if (this.context == Context.PLAYER) {
            boolean value = SettingsManager.getPlayerSettingOrDefault(player, ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), setting) == false;
            SettingsManager.setPlayerSetting(player, ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), setting, value);
            this.sendSettingValueToServer(setting, value);
        } else {
            boolean value = SettingsManager.getSettingValue(player, ((MainSettingsCategory)this.getCategory()).getPlayerSettingsTagName(), (MainSettingsCategory)this.getCategory(), setting) == false;
            this.sendSettingValueToServer(setting, value);
        }
    }

    private void sendSettingValueToServer(MainSetting<Boolean> setting, boolean value) {
        CompoundTag data = new CompoundTag();
        setting.setValue(data, value);
        this.sendDataToServer(() -> data);
    }
}

