/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;

public class SyncTemplateSettingsMessage {
    private final Map<Integer, CompoundTag> playerTemplates;

    public SyncTemplateSettingsMessage(Map<Integer, CompoundTag> playerTemplates) {
        this.playerTemplates = playerTemplates;
    }

    public static void encode(SyncTemplateSettingsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.playerTemplates.size());
        msg.playerTemplates.forEach((k, v) -> {
            packetBuffer.writeInt(k.intValue());
            packetBuffer.m_130079_(v);
        });
    }

    public static SyncTemplateSettingsMessage decode(FriendlyByteBuf packetBuffer) {
        int numberOfRecords = packetBuffer.readInt();
        HashMap<Integer, CompoundTag> playerTemplates = new HashMap<Integer, CompoundTag>();
        for (int i = 0; i < numberOfRecords; ++i) {
            playerTemplates.put(packetBuffer.readInt(), packetBuffer.m_130260_());
        }
        return new SyncTemplateSettingsMessage(playerTemplates);
    }

    public static void onMessage(SyncTemplateSettingsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncTemplateSettingsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(SyncTemplateSettingsMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        SettingsTemplateStorage settingsTemplateStorage = SettingsTemplateStorage.get();
        message.playerTemplates.forEach((k, v) -> settingsTemplateStorage.putPlayerTemplate((Player)player, (int)k, (CompoundTag)v));
    }
}

