/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerServer;

public class TransferRecipeMessage {
    private final Map<Integer, Integer> matchingItems;
    private final List<Integer> craftingSlotIndexes;
    private final List<Integer> inventorySlotIndexes;
    private final boolean maxTransfer;

    public TransferRecipeMessage(Map<Integer, Integer> matchingItems, List<Integer> craftingSlotIndexes, List<Integer> inventorySlotIndexes, boolean maxTransfer) {
        this.matchingItems = matchingItems;
        this.craftingSlotIndexes = craftingSlotIndexes;
        this.inventorySlotIndexes = inventorySlotIndexes;
        this.maxTransfer = maxTransfer;
    }

    public static void encode(TransferRecipeMessage msg, FriendlyByteBuf packetBuffer) {
        TransferRecipeMessage.writeMap(packetBuffer, msg.matchingItems);
        TransferRecipeMessage.writeList(packetBuffer, msg.craftingSlotIndexes);
        TransferRecipeMessage.writeList(packetBuffer, msg.inventorySlotIndexes);
        packetBuffer.writeBoolean(msg.maxTransfer);
    }

    private static void writeMap(FriendlyByteBuf packetBuffer, Map<Integer, Integer> map) {
        packetBuffer.writeInt(map.size());
        map.forEach((key, value) -> {
            packetBuffer.writeInt(key.intValue());
            packetBuffer.writeInt(value.intValue());
        });
    }

    private static void writeList(FriendlyByteBuf packetBuffer, List<Integer> list) {
        packetBuffer.writeInt(list.size());
        list.forEach(arg_0 -> ((FriendlyByteBuf)packetBuffer).writeInt(arg_0));
    }

    public static TransferRecipeMessage decode(FriendlyByteBuf packetBuffer) {
        return new TransferRecipeMessage(TransferRecipeMessage.readMap(packetBuffer), TransferRecipeMessage.readList(packetBuffer), TransferRecipeMessage.readList(packetBuffer), packetBuffer.readBoolean());
    }

    private static Map<Integer, Integer> readMap(FriendlyByteBuf packetBuffer) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(packetBuffer.readInt(), packetBuffer.readInt());
        }
        return ret;
    }

    private static List<Integer> readList(FriendlyByteBuf packetBuffer) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.add(packetBuffer.readInt());
        }
        return ret;
    }

    static void onMessage(TransferRecipeMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransferRecipeMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(TransferRecipeMessage msg, @Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        CraftingContainerRecipeTransferHandlerServer.setItems((Player)sender, msg.matchingItems, msg.craftingSlotIndexes, msg.inventorySlotIndexes, msg.maxTransfer);
    }
}

