/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;

public class ProgressBar
extends WidgetBase {
    private final TextureBlitData progressTexture;
    private final Supplier<Float> getProgress;
    private final ProgressDirection dir;

    public ProgressBar(Position position, TextureBlitData progressTexture, Supplier<Float> getProgress, ProgressDirection dir) {
        super(position, new Dimension(progressTexture.getWidth(), progressTexture.getHeight()));
        this.progressTexture = progressTexture;
        this.getProgress = getProgress;
        this.dir = dir;
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
    }

    @Override
    protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int height = this.progressTexture.getHeight();
        int width = this.progressTexture.getWidth();
        float progress = this.getProgress.get().floatValue();
        if (progress <= 0.0f) {
            return;
        }
        int yOffset = 0;
        if (this.dir == ProgressDirection.BOTTOM_UP) {
            yOffset = (int)((float)height * progress);
            height -= yOffset;
        } else if (this.dir == ProgressDirection.LEFT_RIGHT) {
            width = (int)((float)width * progress);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.progressTexture.getTextureName());
        ProgressBar.m_93133_((PoseStack)matrixStack, (int)this.x, (int)(this.y + yOffset), (float)this.progressTexture.getU(), (float)((float)this.progressTexture.getV() + (float)yOffset), (int)width, (int)height, (int)this.progressTexture.getTextureWidth(), (int)this.progressTexture.getTextureHeight());
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static enum ProgressDirection {
        LEFT_RIGHT,
        BOTTOM_UP;

    }
}

