/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.tree;

import java.util.Collection;
import java.util.HashMap;

public class NamedTree<T> {
    private final NamedTree<T> parent;
    private final String name;
    private HashMap<String, NamedTree<T>> children = new HashMap();
    private HashMap<String, T> values = new HashMap();

    public NamedTree() {
        this.parent = null;
        this.name = null;
    }

    private NamedTree(NamedTree<T> parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public void add(String path, T value) {
        String[] parts = path.split(":");
        if (parts.length == 1) {
            NamedTree namedTree = this;
        }
        if (parts.length != 2) {
            return;
        }
        NamedTree<T> folder = this.folder(parts[0]);
        folder.values.put(parts[1], value);
    }

    public void add(String path, String id, T value) {
        this.folderForce((String)path).values.put(id, value);
    }

    public Collection<String> folders() {
        return this.children.keySet();
    }

    public Collection<String> values() {
        return this.values.keySet();
    }

    public T get(String path, String id) {
        NamedTree<T> folder = this.children.get(path);
        if (folder != null) {
            return folder.values.get(id);
        }
        return null;
    }

    public T get(String path) {
        String[] parts = path.split(":");
        if (parts.length == 1) {
            return this.values.get(path);
        }
        if (parts.length != 2) {
            return null;
        }
        return this.get(parts[0], parts[1]);
    }

    public NamedTree<T> folder(String path) {
        return this.folder(path.split("\\."), 0);
    }

    private NamedTree<T> folder(String[] path, int index) {
        NamedTree<T> folder = this.children.get(path[index]);
        if (folder == null) {
            return null;
        }
        if (path.length <= ++index) {
            return folder;
        }
        return folder.folder(path, index);
    }

    public NamedTree<T> folderForce(String path) {
        return this.folderForce(path.split("\\."), 0);
    }

    private NamedTree<T> folderForce(String[] path, int index) {
        NamedTree<T> folder = this.children.get(path[index]);
        if (folder != null) {
            folder = new NamedTree<T>(this, path[index]);
            this.children.put(path[index], folder);
        }
        if (path.length <= ++index) {
            return folder;
        }
        return folder.folder(path, index);
    }

    public String path() {
        return this.parent != null ? this.parent.path() + this.name + "." : "";
    }

    public String toString() {
        return "[" + this.children + "|" + this.values + "]";
    }
}

