/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiLabel
extends GuiControl {
    protected CompiledText text = CompiledText.createAnySize();

    public GuiLabel(String name) {
        super(name);
    }

    public GuiLabel(String name, int width, int height) {
        super(name, width, height);
    }

    public GuiLabel setDefaultColor(int color) {
        this.text.defaultColor = color;
        return this;
    }

    public GuiLabel setAlign(Align align) {
        this.text.alignment = align;
        return this;
    }

    public GuiLabel setTranslate(String translate) {
        return this.setTitle((Component)Component.m_237115_((String)translate));
    }

    public GuiLabel setTitle(Component component) {
        this.text.setText(component);
        if (this.hasGui()) {
            this.reflow();
        }
        return this;
    }

    public GuiLabel setTitle(List<Component> components) {
        this.text.setText(components);
        if (this.hasGui()) {
            this.reflow();
        }
        return this;
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        this.text.render(matrix);
    }

    @Override
    public void flowX(int width, int preferred) {
        this.text.setDimension(width, Integer.MAX_VALUE);
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        this.text.setMaxHeight(height);
    }

    @Override
    public int getMinWidth() {
        return 10;
    }

    @Override
    public int preferredWidth() {
        return this.text.getTotalWidth();
    }

    @Override
    public int getMinHeight(int width) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    @Override
    public int preferredHeight(int width) {
        return this.text.getTotalHeight();
    }
}

