/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class CreativeItemGroup
extends CreativeModeTab {
    private final String identifier;
    private final Component displayName;
    private final Supplier<ItemStack> icon;
    private Consumer<Consumer<ItemStack>> filler;
    private Comparator<ItemStack> sorter;

    public static CreativeItemGroup create(String modid, String name, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        String identifier = modid + "." + name;
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(identifier, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, ItemLike icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.m_5456_().m_7968_());
    }

    public static CreativeItemGroup create(String modid, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, ItemLike icon) {
        return CreativeItemGroup.create(modid, () -> icon.m_5456_().m_7968_());
    }

    public static CreativeModeTab getBuildingBlocks() {
        return CreativeModeTab.f_40749_;
    }

    public static CreativeModeTab getDecoration() {
        return CreativeModeTab.f_40750_;
    }

    public static CreativeModeTab getRedstone() {
        return CreativeModeTab.f_40751_;
    }

    public static CreativeModeTab getTransportation() {
        return CreativeModeTab.f_40752_;
    }

    public static CreativeModeTab getMisc() {
        return CreativeModeTab.f_40753_;
    }

    public static CreativeModeTab getSearch() {
        return CreativeModeTab.f_40754_;
    }

    public static CreativeModeTab getFood() {
        return CreativeModeTab.f_40755_;
    }

    public static CreativeModeTab getTools() {
        return CreativeModeTab.f_40756_;
    }

    public static CreativeModeTab getCombat() {
        return CreativeModeTab.f_40757_;
    }

    public static CreativeModeTab getBrewing() {
        return CreativeModeTab.f_40758_;
    }

    private CreativeItemGroup(String identifier, String translationKey, Supplier<ItemStack> icon) {
        super(identifier);
        this.identifier = identifier;
        this.displayName = TextComponents.translation(translationKey).get();
        this.icon = icon;
    }

    public CreativeItemGroup filler(Consumer<Consumer<ItemStack>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<ItemStack> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(stack -> TextComponents.itemStack(stack).format()));
    }

    public ItemStack m_6976_() {
        ItemStack stack = this.icon.get();
        if (stack == null || stack.m_41619_()) {
            throw new RuntimeException("Item group '" + this.identifier + "'s icon stack must not be empty!");
        }
        return stack;
    }

    public Component m_40786_() {
        return this.displayName;
    }

    public String m_40783_() {
        return this.identifier;
    }

    public void m_6151_(NonNullList<ItemStack> items) {
        if (this.filler == null) {
            super.m_6151_(items);
        } else {
            this.filler.accept(arg_0 -> items.add(arg_0));
        }
        if (this.sorter != null) {
            items.sort(this.sorter);
        }
    }
}

