/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.lib.ModTags;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class BaseSickleItem
extends DiggerItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseSickleItem(Tier tier, float attackDamage, float attackSpeed, int range, Function<Item.Properties, Item.Properties> properties) {
        super(attackDamage, attackSpeed, tier, ModTags.MINEABLE_WITH_SICKLE, properties.apply(new Item.Properties()));
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.range = range;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        BaseSickleItem baseSickleItem = this;
        if (baseSickleItem instanceof IEnableable) {
            IEnableable enableable = (IEnableable)((Object)baseSickleItem);
            if (enableable.isEnabled()) {
                super.m_6787_(group, items);
            }
        } else {
            super.m_6787_(group, items);
        }
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return BaseSickleItem.isValidMaterial(state) ? this.m_43314_().m_6624_() / 2.0f : super.m_8102_(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return BaseSickleItem.isValidMaterial(state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return this.harvest(stack, player.f_19853_, pos, player);
    }

    public float m_41008_() {
        return this.attackDamage + this.m_43314_().m_6631_();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private boolean harvest(ItemStack stack, Level level, BlockPos pos, Player player) {
        if (level.m_5776_()) {
            return true;
        }
        BlockState state = level.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)level, pos);
        BlockHelper.harvestBlock(stack, level, (ServerPlayer)player, pos);
        if (this.range > 0 && BaseSickleItem.isValidMaterial(state)) {
            BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.range, -this.range, -this.range), (BlockPos)pos.m_7918_(this.range, this.range, this.range)).forEach(aoePos -> {
                if (stack.m_41619_()) {
                    return;
                }
                if (aoePos != pos) {
                    BlockState aoeState = level.m_8055_(aoePos);
                    if (!BaseSickleItem.isValidMaterial(aoeState)) {
                        return;
                    }
                    float aoeHardness = aoeState.m_60800_((BlockGetter)level, aoePos);
                    if (aoeHardness > hardness + 5.0f) {
                        return;
                    }
                    boolean harvested = BlockHelper.harvestAOEBlock(stack, level, (ServerPlayer)player, aoePos.m_7949_());
                    if (harvested && !player.m_150110_().f_35937_ && aoeHardness <= 0.0f && Math.random() < 0.33) {
                        stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
                    }
                }
            });
        }
        return true;
    }

    private static boolean isValidMaterial(BlockState state) {
        Material material = state.m_60767_();
        return state.m_204336_(ModTags.MINEABLE_WITH_SICKLE) || material == Material.f_76274_ || material == Material.f_76300_ || material == Material.f_76302_;
    }
}

