/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialPropertiesHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.BigCannonBreechStrengthHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialPropertiesHandler;
import rbasamoyai.createbigcannons.crafting.BlockRecipesManager;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesHandler;
import rbasamoyai.createbigcannons.network.ClientboundAnimateCannonContraptionPacket;
import rbasamoyai.createbigcannons.network.ClientboundCheckChannelVersionPacket;
import rbasamoyai.createbigcannons.network.ClientboundPreciseMotionSyncPacket;
import rbasamoyai.createbigcannons.network.ClientboundUpdateContraptionPacket;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.network.ServerboundCarriageWheelPacket;
import rbasamoyai.createbigcannons.network.ServerboundFiringActionPacket;
import rbasamoyai.createbigcannons.network.ServerboundSetContainerValuePacket;
import rbasamoyai.createbigcannons.network.ServerboundSetFireRatePacket;

public class CBCRootNetwork {
    private static final Int2ObjectMap<Function<FriendlyByteBuf, ? extends RootPacket>> ID_TO_CONSTRUCTOR = new Int2ObjectOpenHashMap();
    private static final Object2IntMap<Class<? extends RootPacket>> TYPE_TO_ID = new Object2IntOpenHashMap();
    public static final String VERSION = "1.1.0";

    public static void init() {
        int id = 0;
        CBCRootNetwork.addMsg(id++, ClientboundCheckChannelVersionPacket.class, ClientboundCheckChannelVersionPacket::new);
        CBCRootNetwork.addMsg(id++, BlockRecipesManager.ClientboundRecipesPacket.class, BlockRecipesManager.ClientboundRecipesPacket::new);
        CBCRootNetwork.addMsg(id++, ClientboundAnimateCannonContraptionPacket.class, ClientboundAnimateCannonContraptionPacket::new);
        CBCRootNetwork.addMsg(id++, ClientboundUpdateContraptionPacket.class, ClientboundUpdateContraptionPacket::new);
        CBCRootNetwork.addMsg(id++, ClientboundPreciseMotionSyncPacket.class, ClientboundPreciseMotionSyncPacket::new);
        CBCRootNetwork.addMsg(id++, ServerboundCarriageWheelPacket.class, ServerboundCarriageWheelPacket::new);
        CBCRootNetwork.addMsg(id++, ServerboundFiringActionPacket.class, ServerboundFiringActionPacket::new);
        CBCRootNetwork.addMsg(id++, ServerboundSetFireRatePacket.class, ServerboundSetFireRatePacket::new);
        CBCRootNetwork.addMsg(id++, ServerboundSetContainerValuePacket.class, ServerboundSetContainerValuePacket::new);
        CBCRootNetwork.addMsg(id++, MunitionPropertiesHandler.ClientboundMunitionPropertiesPacket.class, MunitionPropertiesHandler.ClientboundMunitionPropertiesPacket::copyOf);
        CBCRootNetwork.addMsg(id++, AutocannonMaterialPropertiesHandler.ClientboundAutocannonMaterialPropertiesPacket.class, AutocannonMaterialPropertiesHandler.ClientboundAutocannonMaterialPropertiesPacket::copyOf);
        CBCRootNetwork.addMsg(id++, BigCannonMaterialPropertiesHandler.ClientboundBigCannonMaterialPropertiesPacket.class, BigCannonMaterialPropertiesHandler.ClientboundBigCannonMaterialPropertiesPacket::copyOf);
        CBCRootNetwork.addMsg(id++, BigCannonBreechStrengthHandler.ClientboundBigCannonBreechStrengthPacket.class, BigCannonBreechStrengthHandler.ClientboundBigCannonBreechStrengthPacket::copyOf);
    }

    private static <T extends RootPacket> void addMsg(int id, Class<T> clazz, Function<FriendlyByteBuf, T> decoder) {
        TYPE_TO_ID.put(clazz, id);
        ID_TO_CONSTRUCTOR.put(id, decoder);
    }

    public static RootPacket constructPacket(FriendlyByteBuf buf, int id) {
        if (!ID_TO_CONSTRUCTOR.containsKey(id)) {
            throw new IllegalStateException("Attempted to deserialize packet with illegal id: " + id);
        }
        return (RootPacket)((Function)ID_TO_CONSTRUCTOR.get(id)).apply(buf);
    }

    public static void writeToBuf(RootPacket pkt, FriendlyByteBuf buf) {
        int id = TYPE_TO_ID.getOrDefault(pkt.getClass(), -1);
        if (id == -1) {
            throw new IllegalStateException("Attempted to serialize packet with illegal id: " + id);
        }
        buf.m_130130_(id);
        pkt.rootEncode(buf);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundCheckChannelVersionPacket(VERSION), player);
    }
}

