/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import rbasamoyai.createbigcannons.CreateBigCannons;

public record ShrapnelProperties(double damage, double spread, int count) {
    public static ShrapnelProperties DEFAULT = new ShrapnelProperties(0.0, 0.0, 0);

    public static ShrapnelProperties fromJson(JsonObject obj, String id) {
        double entityDmg = Math.max(0.0, ShrapnelProperties.getOrWarn(obj, "entity_damage", id, 1.0, JsonElement::getAsDouble));
        double spread = Math.max(0.0, ShrapnelProperties.getOrWarn(obj, "spread", id, 1.0, JsonElement::getAsDouble));
        int count = Math.max(0, ShrapnelProperties.getOrWarn(obj, "count", id, 1, JsonElement::getAsInt));
        return new ShrapnelProperties(entityDmg, spread, count);
    }

    private static <T> T getOrWarn(JsonObject obj, String key, String id, T defValue, Function<JsonElement, T> func) {
        if (!obj.has(key)) {
            CreateBigCannons.LOGGER.warn("{} is missing {} value, will be set to 1", (Object)id, (Object)key);
            return defValue;
        }
        return func.apply((JsonElement)obj.getAsJsonPrimitive(key));
    }

    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("entity_damage", (Number)this.damage);
        obj.addProperty("spread", (Number)this.spread);
        obj.addProperty("count", (Number)this.count);
        return obj;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeDouble(this.damage).writeDouble(this.spread);
        buf.m_130130_(this.count);
    }

    public static ShrapnelProperties readBuf(FriendlyByteBuf buf) {
        return new ShrapnelProperties(buf.readDouble(), buf.readDouble(), buf.m_130242_());
    }
}

