/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;

public abstract class AbstractBigCannonProjectile
extends AbstractCannonProjectile {
    protected AbstractBigCannonProjectile(EntityType<? extends AbstractBigCannonProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    protected void onTickRotate() {
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        if (!this.isInGround()) {
            Vec3 vel = this.m_20184_();
            if (vel.m_82556_() > 0.005) {
                this.m_146922_((float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)vel.f_82480_, (double)vel.m_165924_()) * 57.2957763671875));
            }
            this.m_146922_(AbstractBigCannonProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            this.m_146926_(AbstractBigCannonProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        }
    }

    public abstract BlockState getRenderedBlockState();

    @Override
    @Nullable
    protected ParticleOptions getTrailParticles() {
        return ParticleTypes.f_123778_;
    }

    @Override
    protected void onDestroyBlock(BlockState state, BlockHitResult result) {
        double mass = this.getProjectileMass();
        Vec3 curVel = this.m_20184_();
        double mag = curVel.m_82553_();
        double bonus = 1.0 + Math.max(0.0, (mag - (double)CBCConfigs.SERVER.munitions.minVelocityForPenetrationBonus.getF()) * (double)CBCConfigs.SERVER.munitions.penetrationBonusScale.getF());
        double hardness = BlockHardnessHandler.getHardness(state) / bonus;
        this.setProjectileMass((float)Math.max(mass - hardness, 0.0));
        if (!this.f_19853_.m_5776_()) {
            this.f_19853_.m_46961_(result.m_82425_(), false);
        }
    }

    @Override
    protected boolean canDeflect(BlockHitResult result) {
        return super.canDeflect(result) && this.f_19796_.m_188501_() < CBCConfigs.SERVER.munitions.bigCannonDeflectChance.getF();
    }

    @Override
    protected boolean canBounceOffOf(BlockState state) {
        return super.canBounceOffOf(state) && this.f_19796_.m_188501_() < CBCConfigs.SERVER.munitions.bigCannonDeflectChance.getF();
    }

    @Override
    protected DamageSource getEntityDamage() {
        return new CannonDamageSource("createbigcannons.big_cannon_projectile", (Entity)this, null);
    }
}

